"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateVolatileSearchSource = updateVolatileSearchSource;
var _public = require("@kbn/data-views-plugin/public");
var _common = require("../../../../common");
var _sorting = require("../../../utils/sorting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Helper function to update the given searchSource before fetching/sharing/persisting
 */
function updateVolatileSearchSource(searchSource, {
  dataView,
  services,
  sort
}) {
  const {
    uiSettings,
    data
  } = services;
  const usedSort = (0, _sorting.getSortForSearchSource)(sort, dataView, uiSettings.get(_common.SORT_DEFAULT_ORDER_SETTING));
  const useNewFieldsApi = !uiSettings.get(_common.SEARCH_FIELDS_FROM_SOURCE);
  searchSource.setField('trackTotalHits', true).setField('sort', usedSort);
  if (dataView.type !== _public.DataViewType.ROLLUP) {
    // Set the date range filter fields from timeFilter using the absolute format. Search sessions requires that it be converted from a relative range
    searchSource.setField('filter', data.query.timefilter.timefilter.createFilter(dataView));
  }
  if (useNewFieldsApi) {
    searchSource.removeField('fieldsFromSource');
    const fields = {
      field: '*'
    };
    fields.include_unmapped = 'true';
    searchSource.setField('fields', [fields]);
  } else {
    searchSource.removeField('fields');
  }
}