"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSavedSearchInitial = exports.useSavedSearch = exports.DiscoverStateProvider = exports.DiscoverMainProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _discover_internal_state_container = require("./discover_internal_state_container");
var _discover_app_state_container = require("./discover_app_state_container");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function createStateHelpers() {
  const context = /*#__PURE__*/_react.default.createContext(null);
  const useContainer = () => (0, _react.useContext)(context);
  const useSavedSearch = () => {
    const container = useContainer();
    return (0, _useObservable.default)(container.savedSearchState.getCurrent$(), container.savedSearchState.getCurrent$().getValue());
  };
  const useSavedSearchInitial = () => {
    const container = useContainer();
    return (0, _useObservable.default)(container.savedSearchState.getInitial$(), container.savedSearchState.getInitial$().getValue());
  };
  return {
    Provider: context.Provider,
    useSavedSearch,
    useSavedSearchInitial
  };
}
const {
  Provider: DiscoverStateProvider,
  useSavedSearchInitial,
  useSavedSearch
} = createStateHelpers();
exports.useSavedSearch = useSavedSearch;
exports.useSavedSearchInitial = useSavedSearchInitial;
exports.DiscoverStateProvider = DiscoverStateProvider;
const DiscoverMainProvider = ({
  value,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(DiscoverStateProvider, {
    value: value
  }, /*#__PURE__*/_react.default.createElement(_discover_app_state_container.DiscoverAppStateProvider, {
    value: value.appState
  }, /*#__PURE__*/_react.default.createElement(_discover_internal_state_container.InternalStateProvider, {
    value: value.internalState
  }, children)));
};
exports.DiscoverMainProvider = DiscoverMainProvider;