"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertResultsToast = exports.displayPossibleDocsDiffInfoAlert = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const displayPossibleDocsDiffInfoAlert = toastNotifications => {
  const infoTitle = _i18n.i18n.translate('discover.viewAlert.documentsMayVaryInfoTitle', {
    defaultMessage: 'Displayed documents may vary'
  });
  const infoDescription = _i18n.i18n.translate('discover.viewAlert.documentsMayVaryInfoDescription', {
    defaultMessage: `The displayed documents might differ from the documents that triggered the alert.
         Some documents might have been added or deleted.`
  });
  toastNotifications.addInfo({
    title: infoTitle,
    text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public.MarkdownSimple, null, infoDescription))
  });
};
exports.displayPossibleDocsDiffInfoAlert = displayPossibleDocsDiffInfoAlert;
const useAlertResultsToast = ({
  isAlertResults,
  toastNotifications
}) => {
  (0, _react.useEffect)(() => {
    if (isAlertResults) {
      displayPossibleDocsDiffInfoAlert(toastNotifications);
    }
  }, [isAlertResults, toastNotifications]);
};
exports.useAlertResultsToast = useAlertResultsToast;