"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverMainApp = DiscoverMainApp;
var _react = _interopRequireWildcard(require("react"));
var _domDragDrop = require("@kbn/dom-drag-drop");
var _use_url_tracking = require("./hooks/use_url_tracking");
var _layout = require("./components/layout");
var _breadcrumbs = require("../../utils/breadcrumbs");
var _help_menu_util = require("../../components/help_menu/help_menu_util");
var _use_discover_services = require("../../hooks/use_discover_services");
var _saved_search_alias_match_redirect = require("../../hooks/saved_search_alias_match_redirect");
var _discover_state_provider = require("./services/discover_state_provider");
var _use_adhoc_data_views = require("./hooks/use_adhoc_data_views");
var _use_text_based_query_language = require("./hooks/use_text_based_query_language");
var _add_log = require("../../utils/add_log");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DiscoverLayoutMemoized = /*#__PURE__*/_react.default.memo(_layout.DiscoverLayout);
function DiscoverMainApp(props) {
  const {
    stateContainer
  } = props;
  const savedSearch = (0, _discover_state_provider.useSavedSearchInitial)();
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    chrome,
    docLinks,
    data,
    spaces,
    history
  } = services;
  (0, _use_url_tracking.useUrlTracking)(stateContainer.savedSearchState);

  /**
   * Adhoc data views functionality
   */
  (0, _use_adhoc_data_views.useAdHocDataViews)({
    stateContainer,
    services
  });

  /**
   * State changes (data view, columns), when a text base query result is returned
   */
  (0, _use_text_based_query_language.useTextBasedQueryLanguage)({
    dataViews: services.dataViews,
    stateContainer
  });
  /**
   * Start state syncing and fetch data if necessary
   */
  (0, _react.useEffect)(() => {
    const unsubscribe = stateContainer.actions.initializeAndSync();
    (0, _add_log.addLog)('[DiscoverMainApp] state container initialization triggers data fetching');
    stateContainer.actions.fetchData(true);
    return () => unsubscribe();
  }, [stateContainer]);

  /**
   * SavedSearch dependend initializing
   */
  (0, _react.useEffect)(() => {
    const pageTitleSuffix = savedSearch.id && savedSearch.title ? `: ${savedSearch.title}` : '';
    chrome.docTitle.change(`Discover${pageTitleSuffix}`);
    (0, _breadcrumbs.setBreadcrumbsTitle)({
      title: savedSearch.title,
      services
    });
  }, [chrome.docTitle, savedSearch.id, savedSearch.title, services]);
  (0, _react.useEffect)(() => {
    (0, _help_menu_util.addHelpMenuToAppChrome)(chrome, docLinks);
  }, [chrome, docLinks]);
  (0, _react.useEffect)(() => {
    return () => {
      // clear session when navigating away from discover main
      data.search.session.clear();
    };
  }, [data.search.session]);
  (0, _saved_search_alias_match_redirect.useSavedSearchAliasMatchRedirect)({
    savedSearch,
    spaces,
    history
  });
  return /*#__PURE__*/_react.default.createElement(_domDragDrop.RootDragDropProvider, null, /*#__PURE__*/_react.default.createElement(DiscoverLayoutMemoized, {
    stateContainer: stateContainer
  }));
}