"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverSidebar = void 0;
exports.DiscoverSidebarComponent = DiscoverSidebarComponent;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./discover_sidebar.scss");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-search-plugin/public");
var _public2 = require("@kbn/data-views-plugin/public");
var _public3 = require("@kbn/unified-field-list-plugin/public");
var _discover_app_state_container = require("../../services/discover_app_state_container");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _discover_field = require("./discover_field");
var _common = require("../../../../../common");
var _group_fields = require("./lib/group_fields");
var _get_raw_record_type = require("../../utils/get_raw_record_type");
var _discover_data_state_container = require("../../services/discover_data_state_container");
var _customizations = require("../../../../customizations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DiscoverSidebarComponent({
  isProcessing,
  alwaysShowActionButtons = false,
  columns,
  allFields,
  onAddField,
  onAddFilter,
  onRemoveField,
  selectedDataView,
  trackUiMetric,
  useNewFieldsApi = false,
  onFieldEdited,
  onChangeDataView,
  setFieldEditorRef,
  closeFlyout,
  editField,
  viewMode,
  createNewDataView,
  showDataViewPicker,
  showFieldList,
  isAffectedByGlobalFilter
}) {
  const {
    uiSettings,
    dataViewFieldEditor,
    dataViews,
    core
  } = (0, _use_discover_services.useDiscoverServices)();
  const isPlainRecord = (0, _discover_app_state_container.useAppStateSelector)(state => (0, _get_raw_record_type.getRawRecordType)(state.query) === _discover_data_state_container.RecordRawType.PLAIN);
  const [selectedFieldsState, setSelectedFieldsState] = (0, _react.useState)(_group_fields.INITIAL_SELECTED_FIELDS_RESULT);
  const [multiFieldsMap, setMultiFieldsMap] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    const result = (0, _group_fields.getSelectedFields)({
      dataView: selectedDataView,
      columns,
      allFields,
      isPlainRecord
    });
    setSelectedFieldsState(result);
  }, [selectedDataView, columns, setSelectedFieldsState, allFields, isPlainRecord]);
  (0, _react.useEffect)(() => {
    if (isPlainRecord || !useNewFieldsApi) {
      setMultiFieldsMap(undefined); // we don't have to calculate multifields in this case
    } else {
      setMultiFieldsMap(calculateMultiFields(allFields, selectedFieldsState.selectedFieldsMap, useNewFieldsApi));
    }
  }, [selectedFieldsState.selectedFieldsMap, allFields, useNewFieldsApi, setMultiFieldsMap, isPlainRecord]);
  const deleteField = (0, _react.useMemo)(() => editField && selectedDataView ? async fieldName => {
    const ref = dataViewFieldEditor.openDeleteModal({
      ctx: {
        dataView: selectedDataView
      },
      fieldName,
      onDelete: async () => {
        await onFieldEdited({
          removedFieldName: fieldName
        });
      }
    });
    if (setFieldEditorRef) {
      setFieldEditorRef(ref);
    }
    if (closeFlyout) {
      closeFlyout();
    }
  } : undefined, [selectedDataView, editField, setFieldEditorRef, closeFlyout, onFieldEdited, dataViewFieldEditor]);
  const popularFieldsLimit = (0, _react.useMemo)(() => uiSettings.get(_common.FIELDS_LIMIT_SETTING), [uiSettings]);
  const onSupportedFieldFilter = (0, _react.useCallback)(field => {
    return (0, _group_fields.shouldShowField)(field, isPlainRecord);
  }, [isPlainRecord]);
  const onOverrideFieldGroupDetails = (0, _react.useCallback)(groupName => {
    if (groupName === _public3.FieldsGroupNames.AvailableFields) {
      return {
        helpText: _i18n.i18n.translate('discover.fieldChooser.availableFieldsTooltip', {
          defaultMessage: 'Fields available for display in the table.'
        })
      };
    }
  }, []);
  const {
    fieldListFiltersProps,
    fieldListGroupedProps
  } = (0, _public3.useGroupedFields)({
    dataViewId: !isPlainRecord && (selectedDataView === null || selectedDataView === void 0 ? void 0 : selectedDataView.id) || null,
    // passing `null` for text-based queries
    allFields,
    popularFieldsLimit: !isPlainRecord ? popularFieldsLimit : 0,
    sortedSelectedFields: selectedFieldsState.selectedFields,
    isAffectedByGlobalFilter,
    services: {
      dataViews,
      core
    },
    onSupportedFieldFilter,
    onOverrideFieldGroupDetails
  });
  const renderFieldItem = (0, _react.useCallback)(({
    field,
    groupName,
    groupIndex,
    itemIndex,
    fieldSearchHighlight
  }) => /*#__PURE__*/_react.default.createElement("li", {
    key: `field${field.name}`,
    "data-attr-field": field.name
  }, /*#__PURE__*/_react.default.createElement(_discover_field.DiscoverField, {
    alwaysShowActionButton: alwaysShowActionButtons,
    field: field,
    highlight: fieldSearchHighlight,
    dataView: selectedDataView,
    onAddField: onAddField,
    onRemoveField: onRemoveField,
    onAddFilter: onAddFilter,
    trackUiMetric: trackUiMetric,
    multiFields: multiFieldsMap === null || multiFieldsMap === void 0 ? void 0 : multiFieldsMap.get(field.name) // ideally we better calculate multifields when they are requested first from the popover
    ,
    onEditField: editField,
    onDeleteField: deleteField,
    contextualFields: columns,
    groupIndex: groupIndex,
    itemIndex: itemIndex,
    isEmpty: groupName === _public3.FieldsGroupNames.EmptyFields,
    isSelected: groupName === _public3.FieldsGroupNames.SelectedFields || Boolean(selectedFieldsState.selectedFieldsMap[field.name])
  })), [alwaysShowActionButtons, selectedDataView, onAddField, onRemoveField, onAddFilter, trackUiMetric, multiFieldsMap, editField, deleteField, columns, selectedFieldsState.selectedFieldsMap]);
  const searchBarCustomization = (0, _customizations.useDiscoverCustomization)('search_bar');
  if (!selectedDataView) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSidebar, {
    className: "dscSidebar",
    "aria-label": _i18n.i18n.translate('discover.fieldChooser.filter.indexAndFieldsSectionAriaLabel', {
      defaultMessage: 'Index and fields'
    }),
    id: "discover-sidebar",
    "data-test-subj": "discover-sidebar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "dscSidebar__group",
    direction: "column",
    alignItems: "stretch",
    gutterSize: "s",
    responsive: false
  }, Boolean(showDataViewPicker) && (searchBarCustomization !== null && searchBarCustomization !== void 0 && searchBarCustomization.CustomDataViewPicker ? /*#__PURE__*/_react.default.createElement(searchBarCustomization.CustomDataViewPicker, null) : /*#__PURE__*/_react.default.createElement(_public.DataViewPicker, {
    currentDataViewId: selectedDataView.id,
    onChangeDataView: onChangeDataView,
    onAddField: editField,
    onDataViewCreated: createNewDataView,
    trigger: {
      label: (selectedDataView === null || selectedDataView === void 0 ? void 0 : selectedDataView.getName()) || '',
      'data-test-subj': 'dataView-switch-link',
      title: (selectedDataView === null || selectedDataView === void 0 ? void 0 : selectedDataView.getIndexPattern()) || '',
      fullWidth: true
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public3.FieldList, {
    isProcessing: isProcessing,
    prepend: /*#__PURE__*/_react.default.createElement(_public3.FieldListFilters, fieldListFiltersProps),
    className: "dscSidebar__list"
  }, showFieldList ? /*#__PURE__*/_react.default.createElement(_public3.FieldListGrouped, (0, _extends2.default)({}, fieldListGroupedProps, {
    renderFieldItem: renderFieldItem,
    localStorageKeyPrefix: "discover"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }), !!editField && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "indexOpen",
    "data-test-subj": "dataView-add-field_btn",
    onClick: () => editField(),
    size: "s"
  }, _i18n.i18n.translate('discover.fieldChooser.addField.label', {
    defaultMessage: 'Add a field'
  })))))));
}
const DiscoverSidebar = /*#__PURE__*/(0, _react.memo)(DiscoverSidebarComponent);
exports.DiscoverSidebar = DiscoverSidebar;
function calculateMultiFields(allFields, selectedFieldsMap, useNewFieldsApi) {
  if (!useNewFieldsApi || !allFields) {
    return undefined;
  }
  const map = new Map();
  allFields.forEach(field => {
    var _map$get;
    const subTypeMulti = (0, _public2.getFieldSubtypeMulti)(field);
    const parent = subTypeMulti === null || subTypeMulti === void 0 ? void 0 : subTypeMulti.multi.parent;
    if (!parent) {
      return;
    }
    const multiField = {
      field,
      isSelected: Boolean(selectedFieldsMap === null || selectedFieldsMap === void 0 ? void 0 : selectedFieldsMap[field.name])
    };
    const value = (_map$get = map.get(parent)) !== null && _map$get !== void 0 ? _map$get : [];
    value.push(multiField);
    map.set(parent, value);
  });
  return map;
}