"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverFieldStats = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/unified-field-list-plugin/public");
var _use_discover_services = require("../../../../hooks/use_discover_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DiscoverFieldStats = /*#__PURE__*/_react.default.memo(({
  field,
  dataView,
  multiFields,
  onAddFilter
}) => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const querySubscriberResult = (0, _public.useQuerySubscriber)({
    data: services.data
  });
  // prioritize an aggregatable multi field if available or take the parent field
  const fieldForStats = (0, _react.useMemo)(() => {
    var _multiFields$find;
    return (multiFields === null || multiFields === void 0 ? void 0 : multiFields.length) && ((_multiFields$find = multiFields.find(multiField => multiField.field.aggregatable)) === null || _multiFields$find === void 0 ? void 0 : _multiFields$find.field) || field;
  }, [field, multiFields]);
  if (!(0, _public.hasQuerySubscriberData)(querySubscriberResult)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_public.FieldStats, {
    services: services,
    query: querySubscriberResult.query,
    filters: querySubscriberResult.filters,
    fromDate: querySubscriberResult.fromDate,
    toDate: querySubscriberResult.toDate,
    dataViewOrDataViewId: dataView,
    field: fieldForStats,
    "data-test-subj": "dscFieldStats",
    onAddFilter: onAddFilter
  });
});
exports.DiscoverFieldStats = DiscoverFieldStats;