"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./discover_field.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-field-list-plugin/public");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _discover_field_stats = require("./discover_field_stats");
var _common = require("../../../../../common");
var _kibana_services = require("../../../../kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getCommonFieldItemButtonProps({
  field,
  isSelected,
  toggleDisplay
}) {
  const handler = field.name === '_source' ? undefined : f => toggleDisplay(f, isSelected);
  return {
    field,
    isSelected,
    buttonAddFieldToWorkspaceProps: {
      'aria-label': _i18n.i18n.translate('discover.fieldChooser.discoverField.addFieldTooltip', {
        defaultMessage: 'Add field as column'
      })
    },
    buttonRemoveFieldFromWorkspaceProps: {
      'aria-label': _i18n.i18n.translate('discover.fieldChooser.discoverField.removeFieldTooltip', {
        defaultMessage: 'Remove field from table'
      })
    },
    onAddFieldToWorkspace: handler,
    onRemoveFieldFromWorkspace: handler
  };
}
const MultiFields = /*#__PURE__*/(0, _react.memo)(({
  multiFields,
  toggleDisplay,
  alwaysShowActionButton
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xxxs"
}, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('discover.fieldChooser.discoverField.multiFields', {
  defaultMessage: 'Multi fields'
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), multiFields.map(entry => /*#__PURE__*/_react.default.createElement(_public.FieldItemButton, (0, _extends2.default)({
  key: entry.field.name,
  size: "xs",
  className: "dscSidebarItem dscSidebarItem--multi",
  flush: "both",
  isEmpty: false,
  isActive: false,
  shouldAlwaysShowAction: alwaysShowActionButton,
  onClick: undefined
}, getCommonFieldItemButtonProps({
  field: entry.field,
  isSelected: entry.isSelected,
  toggleDisplay
}))))));
function DiscoverFieldComponent({
  alwaysShowActionButton = false,
  field,
  highlight,
  dataView,
  onAddField,
  onRemoveField,
  onAddFilter,
  isEmpty,
  isSelected,
  trackUiMetric,
  multiFields,
  onEditField,
  onDeleteField,
  contextualFields,
  groupIndex,
  itemIndex
}) {
  const [infoIsOpen, setOpen] = (0, _react.useState)(false);
  const isDocumentRecord = !!onAddFilter;
  const addFilterAndClosePopover = (0, _react.useMemo)(() => onAddFilter ? (...params) => {
    setOpen(false);
    onAddFilter === null || onAddFilter === void 0 ? void 0 : onAddFilter(...params);
  } : undefined, [setOpen, onAddFilter]);
  const togglePopover = (0, _react.useCallback)(() => {
    setOpen(value => !value);
  }, [setOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setOpen(false);
  }, [setOpen]);
  const toggleDisplay = (0, _react.useCallback)((f, isCurrentlySelected) => {
    closePopover();
    if (isCurrentlySelected) {
      onRemoveField(f.name);
    } else {
      onAddField(f.name);
    }
  }, [onAddField, onRemoveField, closePopover]);
  const rawMultiFields = (0, _react.useMemo)(() => multiFields === null || multiFields === void 0 ? void 0 : multiFields.map(f => f.field), [multiFields]);
  const customPopoverHeaderProps = (0, _react.useMemo)(() => ({
    buttonAddFieldToWorkspaceProps: {
      'aria-label': _i18n.i18n.translate('discover.fieldChooser.discoverField.addFieldTooltip', {
        defaultMessage: 'Add field as column'
      })
    },
    buttonAddFilterProps: {
      'data-test-subj': `discoverFieldListPanelAddExistFilter-${field.name}`
    },
    buttonEditFieldProps: {
      'data-test-subj': `discoverFieldListPanelEdit-${field.name}`
    },
    buttonDeleteFieldProps: {
      'data-test-subj': `discoverFieldListPanelDelete-${field.name}`
    }
  }), [field.name]);
  const renderPopover = () => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_discover_field_stats.DiscoverFieldStats, {
      field: field,
      multiFields: multiFields,
      dataView: dataView,
      onAddFilter: addFilterAndClosePopover
    }), multiFields && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(MultiFields, {
      multiFields: multiFields,
      alwaysShowActionButton: alwaysShowActionButton,
      toggleDisplay: toggleDisplay
    })), /*#__PURE__*/_react.default.createElement(_public.FieldPopoverFooter, {
      field: field,
      dataView: dataView,
      multiFields: rawMultiFields,
      trackUiMetric: trackUiMetric,
      contextualFields: contextualFields,
      originatingApp: _common.PLUGIN_ID,
      uiActions: (0, _kibana_services.getUiActions)(),
      closePopover: () => closePopover()
    }));
  };
  const value = (0, _react.useMemo)(() => ({
    id: field.name,
    humanData: {
      label: field.displayName,
      position: itemIndex + 1
    }
  }), [field, itemIndex]);
  const order = (0, _react.useMemo)(() => [0, groupIndex, itemIndex], [groupIndex, itemIndex]);
  return /*#__PURE__*/_react.default.createElement(_public.FieldPopover, {
    isOpen: infoIsOpen,
    button: /*#__PURE__*/_react.default.createElement(_domDragDrop.DragDrop, {
      draggable: true,
      order: order,
      value: value,
      onDragStart: closePopover,
      isDisabled: alwaysShowActionButton,
      dataTestSubj: `dscFieldListPanelField-${field.name}`
    }, /*#__PURE__*/_react.default.createElement(_public.FieldItemButton, (0, _extends2.default)({
      size: "xs",
      fieldSearchHighlight: highlight,
      className: "dscSidebarItem",
      isEmpty: isEmpty,
      isActive: infoIsOpen,
      flush: alwaysShowActionButton ? 'both' : undefined,
      shouldAlwaysShowAction: alwaysShowActionButton,
      onClick: field.type !== '_source' ? togglePopover : undefined
    }, getCommonFieldItemButtonProps({
      field,
      isSelected,
      toggleDisplay
    })))),
    closePopover: closePopover,
    "data-test-subj": "discoverFieldListPanelPopover",
    renderHeader: () => /*#__PURE__*/_react.default.createElement(_public.FieldPopoverHeader, (0, _extends2.default)({
      field: field,
      closePopover: closePopover,
      onAddFieldToWorkspace: !isSelected ? toggleDisplay : undefined,
      onAddFilter: onAddFilter,
      onEditField: onEditField,
      onDeleteField: onDeleteField
    }, customPopoverHeaderProps)),
    renderContent: isDocumentRecord ? renderPopover : undefined
  });
}
const DiscoverField = /*#__PURE__*/(0, _react.memo)(DiscoverFieldComponent);
exports.DiscoverField = DiscoverField;