"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverHistogramLayout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/unified-histogram-plugin/public");
var _react2 = require("@emotion/react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _discover_state_provider = require("../../services/discover_state_provider");
var _use_discover_histogram = require("./use_discover_histogram");
var _discover_main_content = require("./discover_main_content");
var _reset_search_button = require("./reset_search_button");
var _discover_app_state_container = require("../../services/discover_app_state_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const histogramLayoutCss = (0, _react2.css)`
  height: 100%;
`;
const DiscoverHistogramLayout = ({
  isPlainRecord,
  dataView,
  stateContainer,
  resizeRef,
  ...mainContentProps
}) => {
  const {
    dataState
  } = stateContainer;
  const savedSearch = (0, _discover_state_provider.useSavedSearchInitial)();
  const searchSessionId = (0, _useObservable.default)(stateContainer.searchSessionManager.searchSessionId$);
  const hideChart = (0, _discover_app_state_container.useAppStateSelector)(state => state.hideChart);
  const unifiedHistogramProps = (0, _use_discover_histogram.useDiscoverHistogram)({
    stateContainer,
    inspectorAdapters: dataState.inspectorAdapters,
    hideChart,
    isPlainRecord
  });

  // Initialized when the first search has been requested or
  // when in text-based mode since search sessions are not supported
  if (!searchSessionId && !isPlainRecord) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_public.UnifiedHistogramContainer, (0, _extends2.default)({}, unifiedHistogramProps, {
    searchSessionId: searchSessionId,
    requestAdapter: dataState.inspectorAdapters.requests,
    resizeRef: resizeRef,
    appendHitsCounter: savedSearch.id ? /*#__PURE__*/_react.default.createElement(_reset_search_button.ResetSearchButton, {
      resetSavedSearch: stateContainer.actions.undoSavedSearchChanges
    }) : undefined,
    css: histogramLayoutCss
  }), /*#__PURE__*/_react.default.createElement(_discover_main_content.DiscoverMainContent, (0, _extends2.default)({}, mainContentProps, {
    stateContainer: stateContainer,
    dataView: dataView,
    isPlainRecord: isPlainRecord
    // The documents grid doesn't rerender when the chart visibility changes
    // which causes it to render blank space, so we need to force a rerender
    ,
    key: `docKey${hideChart}`
  })));
};
exports.DiscoverHistogramLayout = DiscoverHistogramLayout;