"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatisticsTab = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/unified-field-list-plugin/public");
var _discover_state_provider = require("../../services/discover_state_provider");
var _field_stats_table = require("./field_stats_table");
var _use_discover_services = require("../../../../hooks/use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FieldStatisticsTab = /*#__PURE__*/_react.default.memo(props => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const querySubscriberResult = (0, _public.useQuerySubscriber)({
    data: services.data
  });
  const savedSearch = (0, _discover_state_provider.useSavedSearch)();
  return /*#__PURE__*/_react.default.createElement(_field_stats_table.FieldStatisticsTable, (0, _extends2.default)({}, props, {
    savedSearch: savedSearch,
    query: querySubscriberResult.query,
    filters: querySubscriberResult.filters
  }));
});
exports.FieldStatisticsTab = FieldStatisticsTab;