"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProfile = exports.addProfile = void 0;
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const addProfile = (path, profile) => {
  const trimmedPath = path.trim();
  const hasSlash = trimmedPath.endsWith('/');
  return `${trimmedPath}${hasSlash ? '' : '/'}p/${profile}${hasSlash ? '/' : ''}`;
};
exports.addProfile = addProfile;
const getProfile = path => {
  var _match$isExact;
  const match = (0, _reactRouterDom.matchPath)(path, {
    path: '/p/:profile'
  });
  return {
    profile: match === null || match === void 0 ? void 0 : match.params.profile,
    isProfileRootPath: (_match$isExact = match === null || match === void 0 ? void 0 : match.isExact) !== null && _match$isExact !== void 0 ? _match$isExact : false
  };
};
exports.getProfile = getProfile;