"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExploreDataContextMenuAction = exports.ACTION_EXPLORE_DATA = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var shared = _interopRequireWildcard(require("./shared"));
var _abstract_explore_data_action = require("./abstract_explore_data_action");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTION_EXPLORE_DATA = 'ACTION_EXPLORE_DATA';

/**
 * This is "Explore underlying data" action which appears in the context
 * menu of a dashboard panel.
 */
exports.ACTION_EXPLORE_DATA = ACTION_EXPLORE_DATA;
class ExploreDataContextMenuAction extends _abstract_explore_data_action.AbstractExploreDataAction {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "id", ACTION_EXPLORE_DATA);
    (0, _defineProperty2.default)(this, "type", ACTION_EXPLORE_DATA);
    (0, _defineProperty2.default)(this, "order", 200);
    (0, _defineProperty2.default)(this, "getLocation", async context => {
      const {
        plugins
      } = this.params.start();
      const {
        locator
      } = plugins.discover;
      if (!locator) {
        throw new Error('Discover URL locator not available.');
      }
      const {
        embeddable
      } = context;
      const params = {};
      if (embeddable) {
        params.indexPatternId = shared.getIndexPatterns(embeddable)[0] || undefined;
        const input = embeddable.getInput();
        if (input.timeRange && !params.timeRange) params.timeRange = input.timeRange;
        if (input.query) params.query = input.query;
        if (input.filters) params.filters = [...input.filters, ...(params.filters || [])];
      }
      const location = await locator.getLocation(params);
      return location;
    });
  }
}
exports.ExploreDataContextMenuAction = ExploreDataContextMenuAction;