"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDevToolApp = exports.DevToolApp = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Descriptor for a dev tool. A dev tool works similar to an application
 * registered in the core application service.
 */

class DevToolApp {
  /**
   * The id of the dev tools. This will become part of the URL path
   * (`dev_tools/${devTool.id}`. It has to be unique among registered
   * dev tools.
   */

  /**
   * The human readable name of the dev tool. Should be internationalized.
   * This will be used as a label in the tab above the actual tool.
   * May also be a ReactNode.
   */

  /**
   * Mark the navigation tab as beta.
   */

  /**
   * Flag indicating to disable the tab of this dev tool. Navigating to a
   * disabled dev tool will be treated as the navigation to an unknown route
   * (redirect to the console).
   */

  /**
   * Optional tooltip content of the tab.
   */

  /**
   * Flag indicating whether the dev tool will do routing within the `dev_tools/${devTool.id}/`
   * prefix. If it is set to true, the dev tool is responsible to redirect
   * the user when navigating to unknown URLs within the prefix. If set
   * to false only the root URL of the dev tool will be recognized as valid.
   */

  /**
   * Number used to order the tabs.
   */

  constructor(id, title, mount, enableRouting, order, toolTipContent = '', disabled = false, isBeta) {
    (0, _defineProperty2.default)(this, "id", void 0);
    (0, _defineProperty2.default)(this, "title", void 0);
    (0, _defineProperty2.default)(this, "mount", void 0);
    (0, _defineProperty2.default)(this, "isBeta", void 0);
    (0, _defineProperty2.default)(this, "disabled", void 0);
    (0, _defineProperty2.default)(this, "tooltipContent", void 0);
    (0, _defineProperty2.default)(this, "enableRouting", void 0);
    (0, _defineProperty2.default)(this, "order", void 0);
    this.id = id;
    this.title = title;
    this.mount = mount;
    this.enableRouting = enableRouting;
    this.order = order;
    this.tooltipContent = toolTipContent;
    this.disabled = disabled;
    this.isBeta = isBeta;
  }
  enable() {
    this.disabled = false;
  }
  disable() {
    this.disabled = true;
  }
  isDisabled() {
    return this.disabled;
  }
}
exports.DevToolApp = DevToolApp;
const createDevToolApp = ({
  id,
  title,
  mount,
  enableRouting,
  order,
  tooltipContent,
  disabled,
  isBeta
}) => new DevToolApp(id, title, mount, enableRouting, order, tooltipContent, disabled, isBeta);
exports.createDevToolApp = createDevToolApp;