"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkNonAggregatableFieldExistsRequest = exports.checkAggregatableFieldsExistRequest = void 0;
exports.isAggregatableFieldOverallStats = isAggregatableFieldOverallStats;
exports.isNonAggregatableFieldOverallStats = isNonAggregatableFieldOverallStats;
exports.processNonAggregatableFieldsExistResponse = exports.processAggregatableFieldsExistResponse = void 0;
var _lodash = require("lodash");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _build_random_sampler_agg = require("./build_random_sampler_agg");
var _datafeed_utils = require("../../../../../common/utils/datafeed_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const checkAggregatableFieldsExistRequest = (dataViewTitle, query, aggregatableFields, samplingOption, timeFieldName, earliestMs, latestMs, datafeedConfig, runtimeMappings) => {
  const index = dataViewTitle;
  const size = 0;
  const filterCriteria = (0, _mlQueryUtils.buildBaseFilterCriteria)(timeFieldName, earliestMs, latestMs, query);
  const datafeedAggregations = (0, _datafeed_utils.getDatafeedAggregations)(datafeedConfig);

  // Value count aggregation faster way of checking if field exists than using
  // filter aggregation with exists query.
  const aggs = datafeedAggregations !== undefined ? {
    ...datafeedAggregations
  } : {};

  // Combine runtime fields from the data view as well as the datafeed
  const combinedRuntimeMappings = {
    ...((0, _mlIsPopulatedObject.isPopulatedObject)(runtimeMappings) ? runtimeMappings : {}),
    ...((0, _mlIsPopulatedObject.isPopulatedObject)(datafeedConfig) && (0, _mlIsPopulatedObject.isPopulatedObject)(datafeedConfig.runtime_mappings) ? datafeedConfig.runtime_mappings : {})
  };
  aggregatableFields.forEach(({
    name: field,
    supportedAggs
  }, i) => {
    const safeFieldName = (0, _mlQueryUtils.getSafeAggregationName)(field, i);
    if (supportedAggs.has('count')) {
      aggs[`${safeFieldName}_count`] = {
        filter: {
          exists: {
            field
          }
        }
      };
    }
    if (supportedAggs.has('cardinality')) {
      var _datafeedConfig$scrip;
      let cardinalityField;
      if (datafeedConfig !== null && datafeedConfig !== void 0 && (_datafeedConfig$scrip = datafeedConfig.script_fields) !== null && _datafeedConfig$scrip !== void 0 && _datafeedConfig$scrip.hasOwnProperty(field)) {
        cardinalityField = aggs[`${safeFieldName}_cardinality`] = {
          cardinality: {
            script: datafeedConfig === null || datafeedConfig === void 0 ? void 0 : datafeedConfig.script_fields[field].script
          }
        };
      } else {
        cardinalityField = {
          cardinality: {
            field
          }
        };
      }
      aggs[`${safeFieldName}_cardinality`] = cardinalityField;
    }
  });
  const searchBody = {
    query: {
      bool: {
        filter: filterCriteria
      }
    },
    ...((0, _mlIsPopulatedObject.isPopulatedObject)(aggs) ? {
      aggs: (0, _build_random_sampler_agg.buildAggregationWithSamplingOption)(aggs, samplingOption)
    } : {}),
    ...((0, _mlIsPopulatedObject.isPopulatedObject)(combinedRuntimeMappings) ? {
      runtime_mappings: combinedRuntimeMappings
    } : {})
  };
  return {
    index,
    // @ts-expect-error `track_total_hits` not allowed at top level for `typesWithBodyKey`
    track_total_hits: false,
    size,
    body: searchBody
  };
};
exports.checkAggregatableFieldsExistRequest = checkAggregatableFieldsExistRequest;
function isAggregatableFieldOverallStats(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['aggregatableFields']);
}
function isNonAggregatableFieldOverallStats(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['rawResponse']);
}
const processAggregatableFieldsExistResponse = (responses, aggregatableFields, datafeedConfig) => {
  const stats = {
    aggregatableExistsFields: [],
    aggregatableNotExistsFields: []
  };
  if (!responses || aggregatableFields.length === 0) return stats;
  responses.forEach(({
    rawResponse: body,
    aggregatableFields: aggregatableFieldsChunk
  }) => {
    const aggregations = body.aggregations;
    const aggsPath = ['sample'];
    const sampleCount = aggregations.sample.doc_count;
    aggregatableFieldsChunk.forEach(({
      name: field,
      supportedAggs
    }, i) => {
      const safeFieldName = (0, _mlQueryUtils.getSafeAggregationName)(field, i);
      // Sampler agg will yield doc_count that's bigger than the actual # of sampled records
      // because it uses the stored _doc_count if available
      // https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-doc-count-field.html
      // therefore we need to correct it by multiplying by the sampled probability
      const count = (0, _lodash.get)(aggregations, [...aggsPath, `${safeFieldName}_count`, 'doc_count'], 0);
      const multiplier = count > sampleCount ? (0, _lodash.get)(aggregations, [...aggsPath, 'probability'], 1) : 1;
      if (count > 0) {
        const cardinality = (0, _lodash.get)(aggregations, [...aggsPath, `${safeFieldName}_cardinality`, 'value']);
        stats.aggregatableExistsFields.push({
          fieldName: field,
          existsInDocs: true,
          stats: {
            sampleCount,
            count: count * multiplier,
            cardinality
          }
        });
      } else {
        var _datafeedConfig$scrip2, _datafeedConfig$runti;
        if (datafeedConfig !== null && datafeedConfig !== void 0 && (_datafeedConfig$scrip2 = datafeedConfig.script_fields) !== null && _datafeedConfig$scrip2 !== void 0 && _datafeedConfig$scrip2.hasOwnProperty(field) || datafeedConfig !== null && datafeedConfig !== void 0 && (_datafeedConfig$runti = datafeedConfig.runtime_mappings) !== null && _datafeedConfig$runti !== void 0 && _datafeedConfig$runti.hasOwnProperty(field)) {
          const cardinality = (0, _lodash.get)(aggregations, [...aggsPath, `${safeFieldName}_cardinality`, 'value']);
          stats.aggregatableExistsFields.push({
            fieldName: field,
            existsInDocs: true,
            stats: {
              sampleCount,
              count,
              cardinality
            }
          });
        } else {
          stats.aggregatableNotExistsFields.push({
            fieldName: field,
            existsInDocs: false,
            stats: {}
          });
        }
      }
    });
  });
  return stats;
};
exports.processAggregatableFieldsExistResponse = processAggregatableFieldsExistResponse;
const checkNonAggregatableFieldExistsRequest = (dataViewTitle, query, field, timeFieldName, earliestMs, latestMs, runtimeMappings) => {
  const index = dataViewTitle;
  const size = 0;
  const filterCriteria = (0, _mlQueryUtils.buildBaseFilterCriteria)(timeFieldName, earliestMs, latestMs, query);
  const searchBody = {
    query: {
      bool: {
        filter: filterCriteria
      }
    },
    ...((0, _mlIsPopulatedObject.isPopulatedObject)(runtimeMappings) ? {
      runtime_mappings: runtimeMappings
    } : {})
  };
  if (Array.isArray(filterCriteria)) {
    filterCriteria.push({
      exists: {
        field
      }
    });
  }
  return {
    index,
    // @ts-expect-error `size` not allowed at top level for `typesWithBodyKey`
    size,
    body: searchBody,
    // Small es optimization
    // Since we only need to know if at least 1 doc exists for the query
    track_total_hits: 1
  };
};
exports.checkNonAggregatableFieldExistsRequest = checkNonAggregatableFieldExistsRequest;
const processNonAggregatableFieldsExistResponse = (results, nonAggregatableFields) => {
  const stats = {
    nonAggregatableExistsFields: [],
    nonAggregatableNotExistsFields: []
  };
  if (!results || nonAggregatableFields.length === 0) return stats;
  nonAggregatableFields.forEach(fieldName => {
    const foundField = results.find(r => r.rawResponse.fieldName === fieldName);
    const existsInDocs = foundField !== undefined && foundField.rawResponse.hits.total > 0;
    const fieldData = {
      fieldName,
      existsInDocs
    };
    if (existsInDocs === true) {
      stats.nonAggregatableExistsFields.push(fieldData);
    } else {
      stats.nonAggregatableNotExistsFields.push(fieldData);
    }
  });
  return stats;
};
exports.processNonAggregatableFieldsExistResponse = processNonAggregatableFieldsExistResponse;