"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Failures = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_SIZE = 100;
class Failures extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      page: 0
    });
  }
  _renderPaginationControl() {
    return this.props.failedDocs.length > PAGE_SIZE ? /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
      pageCount: Math.floor(this.props.failedDocs.length / PAGE_SIZE),
      activePage: this.state.page,
      onPageClick: page => this.setState({
        page
      }),
      compressed: true
    }) : null;
  }
  render() {
    const lastDocIndex = this.props.failedDocs.length - 1;
    const startIndex = this.state.page * PAGE_SIZE;
    const endIndex = startIndex + PAGE_SIZE > lastDocIndex ? lastDocIndex : startIndex + PAGE_SIZE;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: "failureList",
      buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importSummary.failedDocumentsButtonLabel",
        defaultMessage: "Failed documents"
      }),
      paddingSize: "m"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "failure-list"
    }, this._renderPaginationControl(), this.props.failedDocs.slice(startIndex, endIndex).map(({
      item,
      reason,
      doc
    }) => /*#__PURE__*/_react.default.createElement("div", {
      key: item
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "error-message"
    }, item, ": ", reason), /*#__PURE__*/_react.default.createElement("div", null, JSON.stringify(doc))))));
  }
}
exports.Failures = Failures;