"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overrides = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _options = require("./options");
var _overrides_validation = require("./overrides_validation");
var _public = require("@kbn/kibana-react-plugin/public");
var _grok_pattern = require("../../../common/util/grok_pattern");
var _overrides_utils = require("./overrides_utils");
var _option_lists = require("./options/option_lists");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatOptions = (0, _options.getFormatOptions)();
const timestampFormatOptions = (0, _options.getTimestampFormatOptions)();
const delimiterOptions = (0, _options.getDelimiterOptions)();
const quoteOptions = (0, _options.getQuoteOptions)();
class OverridesUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "linesToSampleErrors", _i18n.i18n.translate('xpack.dataVisualizer.file.editFlyout.overrides.linesToSampleErrorMessage', {
      defaultMessage: 'Value must be greater than {min} and less than or equal to {max}',
      values: {
        min: _overrides_utils.LINES_TO_SAMPLE_VALUE_MIN,
        max: _overrides_utils.LINES_TO_SAMPLE_VALUE_MAX
      }
    }));
    (0, _defineProperty2.default)(this, "customTimestampFormatErrors", _i18n.i18n.translate('xpack.dataVisualizer.file.editFlyout.overrides.customTimestampFormatErrorMessage', {
      defaultMessage: `Timestamp format must be a combination of these Java date/time formats:
      yy, yyyy, M, MM, MMM, MMMM, d, dd, EEE, EEEE, H, HH, h, mm, ss, S through SSSSSSSSS, a, XX, XXX, zzz`
    }));
    (0, _defineProperty2.default)(this, "applyOverrides", () => {
      const overrides = {
        ...this.state.overrides
      };
      overrides.delimiter = (0, _overrides_utils.convertDelimiterBack)(overrides.delimiter, this.state.customDelimiter);
      if (overrides.timestampFormat === _option_lists.CUSTOM_DROPDOWN_OPTION && this.state.customTimestampFormat !== '') {
        overrides.timestampFormat = this.state.customTimestampFormat;
      }
      this.props.setOverrides(overrides);
    });
    (0, _defineProperty2.default)(this, "onFormatChange", ([opt]) => {
      const format = opt ? opt.label : '';
      this.setOverride({
        format
      });
    });
    (0, _defineProperty2.default)(this, "onTimestampFormatChange", ([opt]) => {
      const timestampFormat = opt ? opt.label : '';
      this.setOverride({
        timestampFormat
      });
      if (opt !== _option_lists.CUSTOM_DROPDOWN_OPTION) {
        this.props.setOverridesValid(true);
      }
    });
    (0, _defineProperty2.default)(this, "onCustomTimestampFormatChange", e => {
      this.setState({
        customTimestampFormat: e.target.value
      });
      // check whether the value is valid and set that to state.
      const {
        isValid,
        errorMessage
      } = (0, _overrides_validation.isTimestampFormatValid)(e.target.value);
      this.setState({
        timestampFormatValid: isValid,
        timestampFormatError: errorMessage
      });
      this.props.setOverridesValid(isValid);
    });
    (0, _defineProperty2.default)(this, "onTimestampFieldChange", ([opt]) => {
      const timestampField = opt ? opt.label : '';
      this.setOverride({
        timestampField
      });
    });
    (0, _defineProperty2.default)(this, "onContainsTimeFieldChange", e => {
      this.setState({
        containsTimeField: e.target.checked
      });
      if (e.target.checked === false) {
        this.setOverride({
          timestampFormat: _constants.NO_TIME_FORMAT
        });
      } else {
        this.setOverride({
          timestampFormat: this.props.originalSettings.timestampFormat
        });
      }
    });
    (0, _defineProperty2.default)(this, "onDelimiterChange", ([opt]) => {
      const delimiter = opt ? opt.label : '';
      this.setOverride({
        delimiter
      });
    });
    (0, _defineProperty2.default)(this, "onCustomDelimiterChange", e => {
      this.setState({
        customDelimiter: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onQuoteChange", ([opt]) => {
      const quote = opt ? opt.label : '';
      this.setOverride({
        quote
      });
    });
    (0, _defineProperty2.default)(this, "onHasHeaderRowChange", e => {
      this.setOverride({
        hasHeaderRow: e.target.checked
      });
    });
    (0, _defineProperty2.default)(this, "onShouldTrimFieldsChange", e => {
      this.setOverride({
        shouldTrimFields: e.target.checked
      });
    });
    (0, _defineProperty2.default)(this, "onCharsetChange", ([opt]) => {
      const charset = opt ? opt.label : '';
      this.setOverride({
        charset
      });
    });
    (0, _defineProperty2.default)(this, "onColumnNameChange", (e, i) => {
      const columnNames = this.state.overrides.columnNames;
      columnNames[i] = e.target.value;
      this.setOverride({
        columnNames
      });
    });
    (0, _defineProperty2.default)(this, "onGrokPatternFieldChange", (e, i) => {
      const name = e.target.value;
      const newGrokPattern = (0, _grok_pattern.replaceFieldInGrokPattern)(this.state.overrides.grokPattern, name, i);
      const newGrokFieldNames = (0, _overrides_utils.getGrokFieldNames)(newGrokPattern, this.state.overrides.grokPattern);
      this.setOverride({
        grokPattern: newGrokPattern,
        grokFieldNames: newGrokFieldNames
      });
    });
    (0, _defineProperty2.default)(this, "grokPatternChange", e => {
      const newGrokPattern = e.target.value;
      const newGrokFieldNames = (0, _overrides_utils.getGrokFieldNames)(newGrokPattern, this.state.overrides.grokPattern);
      this.setOverride({
        grokPattern: newGrokPattern,
        grokFieldNames: newGrokFieldNames
      });
    });
    (0, _defineProperty2.default)(this, "onLinesToSampleChange", e => {
      const linesToSample = +e.target.value;
      this.setOverride({
        linesToSample
      });

      // check whether the value is valid and set that to state.
      const linesToSampleValid = (0, _overrides_utils.isLinesToSampleValid)(linesToSample);
      this.setState({
        linesToSampleValid
      });

      // set the overrides valid setting in the parent component,
      // used to disable the Apply button if any of the overrides are invalid
      this.props.setOverridesValid(linesToSampleValid);
    });
    this.state = {};
  }
  static getDerivedStateFromProps(props, state) {
    const {
      originalSettings
    } = props;
    const {
      charset,
      format,
      hasHeaderRow,
      columnNames,
      delimiter,
      quote,
      shouldTrimFields,
      grokPattern,
      timestampField,
      timestampFormat,
      linesToSample
    } = props.overrides;
    const {
      delimiter: d,
      customDelimiter: customD
    } = (0, _overrides_utils.convertDelimiter)(delimiter === undefined ? originalSettings.delimiter : delimiter);
    const {
      newColumnNames,
      originalColumnNames
    } = (0, _overrides_utils.getColumnNames)(columnNames, originalSettings);
    const newGrokFieldNames = (0, _overrides_utils.getGrokFieldNames)(grokPattern, originalSettings.grokPattern);
    const overrides = {
      charset: charset === undefined ? originalSettings.charset : charset,
      format: format === undefined ? originalSettings.format : format,
      hasHeaderRow: hasHeaderRow === undefined ? originalSettings.hasHeaderRow : hasHeaderRow,
      columnNames: newColumnNames,
      grokFieldNames: newGrokFieldNames,
      delimiter: d,
      quote: quote === undefined ? originalSettings.quote : quote,
      shouldTrimFields: shouldTrimFields === undefined ? originalSettings.shouldTrimFields : shouldTrimFields,
      grokPattern: grokPattern === undefined ? originalSettings.grokPattern : grokPattern,
      timestampFormat: timestampFormat === undefined ? originalSettings.timestampFormat : timestampFormat,
      timestampField: timestampField === undefined ? originalSettings.timestampField : timestampField,
      linesToSample: linesToSample === undefined ? originalSettings.linesToSample : +linesToSample
    };
    return {
      originalColumnNames,
      originalGrokFieldNames: newGrokFieldNames,
      customDelimiter: customD === undefined ? '' : customD,
      customTimestampFormat: '',
      linesToSampleValid: true,
      timestampFormatValid: true,
      timestampFormatError: null,
      containsTimeField: overrides.timestampFormat !== _constants.NO_TIME_FORMAT,
      overrides,
      ...state
    };
  }
  componentDidMount() {
    const originalTimestampFormat = this.props && this.props.originalSettings && this.props.originalSettings.timestampFormat;
    if (typeof this.props.setApplyOverrides === 'function') {
      this.props.setApplyOverrides(this.applyOverrides);
    }
    if (originalTimestampFormat !== undefined) {
      const optionExists = _option_lists.TIMESTAMP_OPTIONS.some(option => option === originalTimestampFormat);
      if (optionExists === false) {
        // Incoming format does not exist in dropdown. Display custom input with incoming format as default value.
        const overrides = {
          ...this.state.overrides
        };
        overrides.timestampFormat = _option_lists.CUSTOM_DROPDOWN_OPTION;
        this.setState({
          customTimestampFormat: originalTimestampFormat,
          overrides
        });
      }
    }
  }
  componentWillUnmount() {
    if (typeof this.props.unsetApplyOverrides === 'function') {
      this.props.unsetApplyOverrides();
    }
  }
  setOverride(o) {
    const overrides = {
      ...this.state.overrides,
      ...o
    };
    this.setState({
      overrides
    });
  }
  render() {
    const {
      fields
    } = this.props;
    const {
      customDelimiter,
      customTimestampFormat,
      originalColumnNames,
      originalGrokFieldNames,
      linesToSampleValid,
      timestampFormatError,
      timestampFormatValid,
      containsTimeField,
      overrides
    } = this.state;
    const {
      timestampFormat,
      timestampField,
      format,
      delimiter,
      quote,
      hasHeaderRow,
      shouldTrimFields,
      // charset,
      columnNames,
      grokFieldNames,
      grokPattern,
      linesToSample
    } = overrides;
    const fieldOptions = getSortedFields(fields);
    const timestampFormatErrorsList = [this.customTimestampFormatErrors, timestampFormatError];
    const docsUrl = this.props.kibana.services.docLinks.links.aggs.date_format_pattern;
    const timestampFormatHelp = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docsUrl,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.dataVisualizer.file.editFlyout.overrides.timestampFormatHelpText', {
      defaultMessage: 'See more on accepted formats'
    })));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      error: this.linesToSampleErrors,
      isInvalid: linesToSampleValid === false,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.linesToSampleFormRowLabel",
        defaultMessage: "Number of lines to sample"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: linesToSample,
      onChange: this.onLinesToSampleChange,
      isInvalid: linesToSampleValid === false
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.dataFormatFormRowLabel",
        defaultMessage: "Data format"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: formatOptions,
      selectedOptions: selectedOption(format),
      onChange: this.onFormatChange,
      singleSelection: {
        asPlainText: true
      },
      isClearable: false
    })), format === _constants.FILE_FORMATS.DELIMITED && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.delimiterFormRowLabel",
        defaultMessage: "Delimiter"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: delimiterOptions,
      selectedOptions: selectedOption(delimiter),
      onChange: this.onDelimiterChange,
      singleSelection: {
        asPlainText: true
      },
      isClearable: false
    })), delimiter === _option_lists.CUSTOM_DROPDOWN_OPTION && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.customDelimiterFormRowLabel",
        defaultMessage: "Custom delimiter"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: customDelimiter,
      onChange: this.onCustomDelimiterChange
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.quoteCharacterFormRowLabel",
        defaultMessage: "Quote character"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: quoteOptions,
      selectedOptions: selectedOption(quote),
      onChange: this.onQuoteChange,
      singleSelection: {
        asPlainText: true
      },
      isClearable: false
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: 'hasHeaderRow',
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.hasHeaderRowLabel",
        defaultMessage: "Has header row"
      }),
      checked: hasHeaderRow,
      onChange: this.onHasHeaderRowChange
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: 'shouldTrimFields',
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.trimFieldsLabel",
        defaultMessage: "Should trim fields"
      }),
      checked: shouldTrimFields,
      onChange: this.onShouldTrimFieldsChange
    }))), format === _constants.FILE_FORMATS.SEMI_STRUCTURED_TEXT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.grokPatternFormRowLabel",
        defaultMessage: "Grok pattern"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      placeholder: grokPattern,
      value: grokPattern,
      onChange: this.grokPatternChange
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: 'shouldTrimFields',
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.containsTimeFieldLabel",
        defaultMessage: "Contains time field"
      }),
      checked: containsTimeField,
      onChange: this.onContainsTimeFieldChange
    })), containsTimeField ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      helpText: timestampFormatHelp,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.timestampFormatFormRowLabel",
        defaultMessage: "Timestamp format"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: timestampFormatOptions,
      selectedOptions: selectedOption(timestampFormat),
      onChange: this.onTimestampFormatChange,
      singleSelection: {
        asPlainText: true
      },
      isClearable: false
    })), timestampFormat === _option_lists.CUSTOM_DROPDOWN_OPTION && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      error: timestampFormatErrorsList,
      isInvalid: timestampFormatValid === false,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.customTimestampFormatFormRowLabel",
        defaultMessage: "Custom timestamp format"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: customTimestampFormat,
      onChange: this.onCustomTimestampFormatChange,
      isInvalid: timestampFormatValid === false
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.editFlyout.overrides.timeFieldFormRowLabel",
        defaultMessage: "Time field"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: fieldOptions,
      selectedOptions: selectedOption(timestampField),
      onChange: this.onTimestampFieldChange,
      singleSelection: {
        asPlainText: true
      },
      isClearable: false
    }))) : null, format === _constants.FILE_FORMATS.DELIMITED && originalColumnNames.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.editFlyout.overrides.editFieldNamesTitle",
      defaultMessage: "Edit field names"
    }))), originalColumnNames.map((f, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: f,
      key: f
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: columnNames[i],
      onChange: e => this.onColumnNameChange(e, i)
    })))), format === _constants.FILE_FORMATS.SEMI_STRUCTURED_TEXT && originalGrokFieldNames.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.editFlyout.overrides.editFieldNamesTitle",
      defaultMessage: "Edit field names"
    }))), originalGrokFieldNames.map((f, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: f,
      key: f
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: grokFieldNames[i],
      onChange: e => this.onGrokPatternFieldChange(e, i, grokPattern)
    })))));
  }
}
const Overrides = (0, _public.withKibana)(OverridesUI);
exports.Overrides = Overrides;
function selectedOption(opt) {
  return [{
    label: opt || ''
  }];
}

// return a list of objects compatible with EuiComboBox
// also sort alphanumerically
function getSortedFields(fields) {
  return fields.map(f => ({
    label: f
  })).sort((a, b) => a.label.localeCompare(b.label, undefined, {
    numeric: true
  }));
}