"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTableSettings = useTableSettings;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_SIZE_OPTIONS = [10, 25, 50, 100];
function useTableSettings(items, pageState, updatePageState) {
  const {
    pageIndex,
    pageSize,
    sortField,
    sortDirection
  } = pageState;
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    var _page$index, _page$size, _ref, _sort$direction;
    const result = {
      ...pageState,
      pageIndex: (_page$index = page === null || page === void 0 ? void 0 : page.index) !== null && _page$index !== void 0 ? _page$index : pageState.pageIndex,
      pageSize: (_page$size = page === null || page === void 0 ? void 0 : page.size) !== null && _page$size !== void 0 ? _page$size : pageState.pageSize,
      sortField: (_ref = sort === null || sort === void 0 ? void 0 : sort.field) !== null && _ref !== void 0 ? _ref : pageState.sortField,
      sortDirection: (_sort$direction = sort === null || sort === void 0 ? void 0 : sort.direction) !== null && _sort$direction !== void 0 ? _sort$direction : pageState.sortDirection
    };
    updatePageState(result);
  }, [pageState, updatePageState]);
  const pagination = (0, _react.useMemo)(() => ({
    pageIndex,
    pageSize,
    totalItemCount: items.length,
    pageSizeOptions: PAGE_SIZE_OPTIONS
  }), [items, pageIndex, pageSize]);
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      field: sortField,
      direction: sortDirection
    }
  }), [sortField, sortDirection]);
  return {
    onTableChange,
    pagination,
    sorting
  };
}