"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentStat = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _fieldTypes = require("@kbn/field-types");
var _mlNumberUtils = require("@kbn/ml-number-utils");
var _kibana_context = require("../../../../../kibana_context");
var _field_vis_config = require("../../../../../../../common/types/field_vis_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentStat = ({
  config,
  showIcon,
  totalCount
}) => {
  const {
    stats
  } = config;
  const {
    services: {
      data: {
        fieldFormats
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  if (stats === undefined) return null;
  const {
    count,
    sampleCount
  } = stats;
  const total = sampleCount !== null && sampleCount !== void 0 ? sampleCount : totalCount;

  // If field exists is docs but we don't have count stats then don't show
  // Otherwise if field doesn't appear in docs at all, show 0%
  const valueCount = count !== null && count !== void 0 ? count : (0, _field_vis_config.isIndexBasedFieldVisConfig)(config) && config.existsInDocs === true ? undefined : 0;
  const docsPercent = valueCount !== undefined && total !== undefined ? `(${(0, _mlNumberUtils.roundToDecimalPlace)(valueCount / total * 100)}%)` : null;
  return valueCount !== undefined ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showIcon ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "document",
    size: 'm',
    className: 'columnHeader__icon'
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs'
  }, fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.NUMBER, [_fieldTypes.ES_FIELD_TYPES.INTEGER]).convert(valueCount), ' ', docsPercent)) : null;
};
exports.DocumentStat = DocumentStat;