"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DateContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _format = require("@elastic/eui/lib/services/format");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _expanded_row_field_header = require("../expanded_row_field_header");
var _document_stats = require("./document_stats");
var _expanded_row_content = require("./expanded_row_content");
var _expanded_row_panel = require("./expanded_row_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-ignore

const TIME_FORMAT = 'MMM D YYYY, HH:mm:ss.SSS';
const DateContent = ({
  config
}) => {
  const {
    stats
  } = config;
  if (stats === undefined) return null;
  const {
    earliest,
    latest
  } = stats;
  const summaryTableTitle = _i18n.i18n.translate('xpack.dataVisualizer.dataGrid.field.cardDate.summaryTableTitle', {
    defaultMessage: 'Summary'
  });
  const summaryTableItems = [{
    function: 'earliest',
    display: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.field.cardDate.earliestLabel",
      defaultMessage: "earliest"
    }),
    value: typeof earliest === 'string' ? earliest : (0, _format.formatDate)(earliest, TIME_FORMAT)
  }, {
    function: 'latest',
    display: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.field.cardDate.latestLabel",
      defaultMessage: "latest"
    }),
    value: typeof latest === 'string' ? latest : (0, _format.formatDate)(latest, TIME_FORMAT)
  }];
  const summaryTableColumns = [{
    name: '',
    field: 'function',
    render: (func, summaryItem) => summaryItem.display,
    width: '70px',
    align: _eui.LEFT_ALIGNMENT
  }, {
    field: 'value',
    name: '',
    render: v => /*#__PURE__*/_react.default.createElement("strong", null, v),
    align: _eui.RIGHT_ALIGNMENT
  }];
  return /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerDateContent'
  }, /*#__PURE__*/_react.default.createElement(_document_stats.DocumentStatsTable, {
    config: config
  }), /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    className: 'dvSummaryTable__wrapper dvPanel__wrapper dvPanel__dateSummary'
  }, /*#__PURE__*/_react.default.createElement(_expanded_row_field_header.ExpandedRowFieldHeader, null, summaryTableTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: 'dvSummaryTable',
    "data-test-subj": 'dataVisualizerDateSummaryTable',
    compressed: true,
    items: summaryTableItems,
    columns: summaryTableColumns,
    tableCaption: summaryTableTitle,
    tableLayout: "auto"
  })));
};
exports.DateContent = DateContent;