"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChoroplethTopValuesLayer = exports.ChoroplethMap = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/maps-plugin/common");
var _fieldTypes = require("@kbn/field-types");
var _kibana_context = require("../../../../../kibana_context");
var _embedded_map = require("../../../embedded_map");
var _expanded_row_panel = require("./expanded_row_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getChoroplethTopValuesLayer = (fieldName, topValues, {
  layerId,
  field
}) => {
  return {
    id: (0, _eui.htmlIdGenerator)()(),
    label: _i18n.i18n.translate('xpack.dataVisualizer.choroplethMap.topValuesCount', {
      defaultMessage: 'Top values count for {fieldName}',
      values: {
        fieldName
      }
    }),
    joins: [{
      // Left join is the id from the type of field (e.g. world_countries)
      leftField: field,
      right: {
        id: 'anomaly_count',
        type: _common.SOURCE_TYPES.TABLE_SOURCE,
        __rows: topValues,
        __columns: [{
          name: 'key',
          type: 'string'
        }, {
          name: 'doc_count',
          type: 'number'
        }],
        // Right join/term is the field in the doc you’re trying to join it to (foreign key - e.g. US)
        term: 'key'
      }
    }],
    sourceDescriptor: {
      type: 'EMS_FILE',
      id: layerId
    },
    style: {
      type: 'VECTOR',
      // @ts-ignore missing style properties. Remove once 'VectorLayerDescriptor' type is updated
      properties: {
        icon: {
          type: _common.STYLE_TYPE.STATIC,
          options: {
            value: 'marker'
          }
        },
        fillColor: {
          type: _common.STYLE_TYPE.DYNAMIC,
          options: {
            color: 'Blue to Red',
            colorCategory: 'palette_0',
            fieldMetaOptions: {
              isEnabled: true,
              sigma: 3
            },
            type: _common.COLOR_MAP_TYPE.ORDINAL,
            field: {
              name: 'doc_count',
              origin: _common.FIELD_ORIGIN.JOIN
            },
            useCustomColorRamp: false
          }
        },
        lineColor: {
          type: _common.STYLE_TYPE.DYNAMIC,
          options: {
            fieldMetaOptions: {
              isEnabled: true
            }
          }
        },
        lineWidth: {
          type: _common.STYLE_TYPE.STATIC,
          options: {
            size: 1
          }
        }
      },
      isTimeAware: true
    },
    type: _common.LAYER_TYPE.GEOJSON_VECTOR
  };
};
exports.getChoroplethTopValuesLayer = getChoroplethTopValuesLayer;
const ChoroplethMap = ({
  stats,
  suggestion
}) => {
  var _ref, _stats$totalDocuments;
  const {
    services: {
      data: {
        fieldFormats
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const {
    fieldName,
    isTopValuesSampled,
    topValues,
    sampleCount
  } = stats;
  const layerList = (0, _react.useMemo)(() => [getChoroplethTopValuesLayer(fieldName || '', topValues || [], suggestion)], [suggestion, fieldName, topValues]);
  if (!stats) return null;
  const totalDocuments = (_ref = (_stats$totalDocuments = stats.totalDocuments) !== null && _stats$totalDocuments !== void 0 ? _stats$totalDocuments : sampleCount) !== null && _ref !== void 0 ? _ref : 0;
  const countsElement = totalDocuments ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, isTopValuesSampled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.choroplethMapTopValues.calculatedFromSampleRecordsLabel",
    defaultMessage: "Calculated from {sampledDocumentsFormatted} sample {sampledDocuments, plural, one {record} other {records}}.",
    values: {
      sampledDocuments: sampleCount,
      sampledDocumentsFormatted: /*#__PURE__*/_react.default.createElement("strong", null, fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.NUMBER, [_fieldTypes.ES_FIELD_TYPES.INTEGER]).convert(sampleCount))
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.choroplethMapTopValues.calculatedFromTotalRecordsLabel",
    defaultMessage: "Calculated from {totalDocumentsFormatted} {totalDocuments, plural, one {record} other {records}}.",
    values: {
      totalDocuments,
      totalDocumentsFormatted: /*#__PURE__*/_react.default.createElement("strong", null, fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.NUMBER, [_fieldTypes.ES_FIELD_TYPES.INTEGER]).convert(totalDocuments !== null && totalDocuments !== void 0 ? totalDocuments : 0))
    }
  })) : null;
  return /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    dataTestSubj: 'fileDataVisualizerChoroplethMapTopValues',
    className: 'dvPanel__wrapper',
    grow: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: 'dvMap__wrapper'
  }, /*#__PURE__*/_react.default.createElement(_embedded_map.EmbeddedMapComponent, {
    layerList: layerList
  })), countsElement);
};
exports.ChoroplethMap = ChoroplethMap;