"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const sourcePlaceholder = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.sourcePlaceholder', {
  defaultMessage: "field filter, accepts wildcards (e.g., `user*` to filter fields starting with 'user')"
});
const AddFilter = ({
  onAddFilter
}) => {
  const [filter, setFilter] = (0, _react.useState)('');
  const onAddButtonClick = (0, _react.useCallback)(() => {
    onAddFilter(filter);
    setFilter('');
  }, [filter, onAddFilter]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 10
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: filter,
    "data-test-subj": "fieldFilterInput",
    onChange: e => setFilter(e.target.value.trim()),
    placeholder: sourcePlaceholder
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "addFieldFilterButton",
    isDisabled: filter.length === 0,
    onClick: onAddButtonClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.editIndexPattern.source.addButtonLabel",
    defaultMessage: "Add"
  }))));
};
exports.AddFilter = AddFilter;