"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const Header = (0, _reactRouterDom.withRouter)(({
  indexPatternId,
  history
}) => {
  const {
    dataViews,
    docLinks
  } = (0, _public.useKibana)().services;
  const links = docLinks === null || docLinks === void 0 ? void 0 : docLinks.links;
  const userEditPermission = dataViews.getCanSaveSync();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.editIndexPattern.scriptedLabel",
    defaultMessage: "Scripted fields can be used in visualizations and displayed in documents. However, they cannot be searched."
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "warning",
    style: {
      marginRight: '4px'
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.editIndexPattern.deprecation",
    defaultMessage: "Scripted fields are deprecated. Use {runtimeDocs} instead.",
    values: {
      runtimeDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: links.runtimeFields.overview
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternManagement.header.runtimeLink",
        defaultMessage: "runtime fields"
      }))
    }
  })))), userEditPermission && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": "addScriptedFieldLink"
  }, (0, _public.reactRouterNavigate)(history, `patterns/${indexPatternId}/create-field/`)), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.editIndexPattern.scripted.addFieldButton",
    defaultMessage: "Add scripted field"
  }))));
});
exports.Header = Header;