"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NumberFormatEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _default = require("../default/default");
var _samples = require("../../samples");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class NumberFormatEditor extends _default.DefaultFormatEditor {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      ..._default.defaultState,
      sampleInputs: [10000, 12.345678, -1, -999, 0.52]
    });
  }
  render() {
    var _this$context$service;
    const {
      format,
      formatParams
    } = this.props;
    const {
      error,
      samples
    } = this.state;
    const defaultPattern = `${format.getParamDefaults().pattern}`;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.number.numeralLabel",
        defaultMessage: "Numeral.js format pattern (Default: {defaultPattern})",
        values: {
          defaultPattern: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, defaultPattern)
        }
      }),
      helpText: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: (_this$context$service = this.context.services.docLinks) === null || _this$context$service === void 0 ? void 0 : _this$context$service.links.indexPatterns.fieldFormattersNumber
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.number.documentationLabel",
        defaultMessage: "Documentation"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "link"
      }))),
      isInvalid: !!error,
      error: error
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": 'numberEditorFormatPattern',
      value: formatParams.pattern,
      placeholder: defaultPattern,
      onChange: e => {
        this.onChange({
          pattern: e.target.value
        });
      },
      isInvalid: !!error
    })), /*#__PURE__*/_react.default.createElement(_samples.FormatEditorSamples, {
      samples: samples
    }));
  }
}
exports.NumberFormatEditor = NumberFormatEditor;
(0, _defineProperty2.default)(NumberFormatEditor, "contextType", _public.context);
(0, _defineProperty2.default)(NumberFormatEditor, "formatId", _constants.formatId);