"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormatField = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../shared_imports");
var _field_editor_context = require("../../field_editor_context");
var _field_format_editor = require("../../field_format_editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FormatField = () => {
  const {
    dataView,
    uiSettings,
    fieldFormats,
    fieldFormatEditors
  } = (0, _field_editor_context.useFieldEditorContext)();
  const isMounted = (0, _react.useRef)(false);
  const [{
    type
  }] = (0, _shared_imports.useFormData)({
    watch: ['name', 'type']
  });
  const {
    getFields,
    isSubmitted
  } = (0, _shared_imports.useFormContext)();
  const [formatError, setFormatError] = (0, _react.useState)();
  // convert from combobox type to values
  const typeValue = type.reduce((collector, item) => {
    if (item.value !== undefined) {
      collector.push(item.value);
    }
    return collector;
  }, []);
  (0, _react.useEffect)(() => {
    if (formatError === undefined) {
      getFields().format.setErrors([]);
    } else {
      getFields().format.setErrors([{
        message: formatError
      }]);
    }
  }, [formatError, getFields]);
  (0, _react.useEffect)(() => {
    if (isMounted.current) {
      getFields().format.reset();
    }
    isMounted.current = true;
  }, [type, getFields]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "format"
  }, ({
    setValue,
    errors,
    value
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isSubmitted && errors.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: errors.map(err => err.message),
      color: "danger",
      iconType: "cross",
      "data-test-subj": "formFormatError"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_field_format_editor.FormatSelectEditor, {
      esTypes: typeValue || ['keyword'],
      indexPattern: dataView,
      fieldFormatEditors: fieldFormatEditors,
      fieldFormats: fieldFormats,
      uiSettings: uiSettings,
      onChange: setValue,
      onError: setFormatError,
      value: value,
      key: typeValue.join(', ')
    }));
  });
};
exports.FormatField = FormatField;