"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _public = require("@kbn/data-views-plugin/public");
var _status_message = require("./status_message");
var _indices_list = require("./indices_list");
var _data_view_editor_service = require("../../data_view_editor_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var ViewMode;
(function (ViewMode) {
  ViewMode["allIndices"] = "allIndices";
  ViewMode["onlyMatchingIndices"] = "onlyMatchingIndices";
})(ViewMode || (ViewMode = {}));
const viewModeButtons = [{
  id: ViewMode.allIndices,
  label: _i18n.i18n.translate('indexPatternEditor.previewPanel.viewModeGroup.allSourcesButton', {
    defaultMessage: 'All sources'
  })
}, {
  id: ViewMode.onlyMatchingIndices,
  label: _i18n.i18n.translate('indexPatternEditor.previewPanel.viewModeGroup.matchingSourcesButton', {
    defaultMessage: 'Matching sources'
  })
}];
const PreviewPanel = ({
  type,
  allowHidden,
  title = '',
  matchedIndices$
}) => {
  const [viewMode, setViewMode] = (0, _react.useState)();
  const matched = (0, _useObservable.default)(matchedIndices$, _data_view_editor_service.matchedIndiciesDefault);
  let currentlyVisibleIndices;
  let currentViewMode;
  if (title.length && !isAboutToIncludeMoreIndices(title) && viewMode !== ViewMode.allIndices || viewMode === ViewMode.onlyMatchingIndices) {
    currentlyVisibleIndices = matched.visibleIndices;
    currentViewMode = ViewMode.onlyMatchingIndices;
  } else {
    currentlyVisibleIndices = matched.allIndices;
    currentViewMode = ViewMode.allIndices;
  }
  const indicesListContent = currentlyVisibleIndices.length ? /*#__PURE__*/_react.default.createElement(_indices_list.IndicesList, {
    "data-test-subj": "createIndexPatternStep1IndicesList",
    query: title,
    indices: currentlyVisibleIndices,
    isExactMatch: indexName => title.length > 0 && matched.exactMatchedIndices.some(index => index.name === indexName)
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_status_message.StatusMessage, {
    matchedIndices: matched,
    showSystemIndices: type === _public.INDEX_PATTERN_TYPE.ROLLUP ? false : true,
    isIncludingSystemIndices: allowHidden,
    query: title
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), Boolean(title) && currentlyVisibleIndices.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('indexPatternEditor.previewPanel.viewModeGroup.legend', {
      defaultMessage: 'Visible sources'
    }),
    options: viewModeButtons,
    idSelected: currentViewMode,
    onChange: id => setViewMode(id)
  }), indicesListContent);
};
exports.PreviewPanel = PreviewPanel;
function isAboutToIncludeMoreIndices(query) {
  return query.trimEnd().endsWith(',');
}