"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedParamsSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const AdvancedParamsSection = ({
  children
}) => {
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  const toggleIsVisible = (0, _react.useCallback)(() => {
    setIsVisible(!isVisible);
  }, [isVisible]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: toggleIsVisible,
    flush: "left",
    "data-test-subj": "toggleAdvancedSetting"
  }, isVisible ? _i18n.i18n.translate('indexPatternEditor.editor.form.advancedSettings.hideButtonLabel', {
    defaultMessage: 'Hide advanced settings'
  }) : _i18n.i18n.translate('indexPatternEditor.editor.form.advancedSettings.showButtonLabel', {
    defaultMessage: 'Show advanced settings'
  })), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: isVisible ? 'block' : 'none'
    },
    "data-test-subj": "advancedSettings"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", null, children)));
};
exports.AdvancedParamsSection = AdvancedParamsSection;