"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInspectActionDescriptor = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
require("./inspect_button.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const InspectFlyout = ({
  searchSession
}) => {
  const renderInfo = () => {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
      languageId: "json",
      value: JSON.stringify(searchSession, null, 2),
      options: {
        readOnly: true,
        lineNumbers: 'off',
        fontSize: 12,
        minimap: {
          enabled: false
        },
        scrollBeyondLastLine: false,
        wordWrap: 'on',
        wrappingIndent: 'indent',
        automaticLayout: true
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "data.sessions.management.flyoutTitle",
    defaultMessage: "Inspect search session"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    className: "searchSessionsFlyout",
    "data-test-subj": "searchSessionsFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "data.sessions.management.flyoutText",
    defaultMessage: "Configuration for this search session"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), renderInfo())));
};
const InspectFlyoutWrapper = ({
  searchSession,
  uiSettings,
  settings,
  theme
}) => {
  const {
    Provider: KibanaReactContextProvider
  } = (0, _public.createKibanaReactContext)({
    uiSettings,
    settings,
    theme
  });
  return /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, null, /*#__PURE__*/_react.default.createElement(InspectFlyout, {
    searchSession: searchSession
  }));
};
const createInspectActionDescriptor = (api, uiSession, core) => ({
  iconType: 'document',
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "data.mgmt.searchSessions.flyoutTitle",
    "aria-label": "Inspect",
    defaultMessage: "Inspect"
  }),
  onClick: async () => {
    const flyoutWrapper = /*#__PURE__*/_react.default.createElement(InspectFlyoutWrapper, {
      uiSettings: core.uiSettings,
      settings: core.settings,
      theme: core.theme,
      searchSession: uiSession
    });
    const overlay = core.overlays.openFlyout((0, _public.toMountPoint)(flyoutWrapper, {
      theme$: core.theme.theme$
    }));
    await overlay.onClose;
  }
});
exports.createInspectActionDescriptor = createInspectActionDescriptor;