"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createExtendActionDescriptor = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/kibana-react-plugin/public");
var _extend_session = _interopRequireDefault(require("../../icons/extend_session.svg"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ExtendConfirm = ({
  ...props
}) => {
  const {
    searchSession,
    api,
    onActionDismiss
  } = props;
  const {
    id,
    name,
    expires
  } = searchSession;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const extendByDuration = _moment.default.duration(api.getExtendByDuration());
  const newExpiration = (0, _moment.default)(expires).add(extendByDuration);
  const title = _i18n.i18n.translate('data.mgmt.searchSessions.extendModal.title', {
    defaultMessage: 'Extend search session expiration'
  });
  const confirm = _i18n.i18n.translate('data.mgmt.searchSessions.extendModal.extendButton', {
    defaultMessage: 'Extend expiration'
  });
  const extend = _i18n.i18n.translate('data.mgmt.searchSessions.extendModal.dontExtendButton', {
    defaultMessage: 'Cancel'
  });
  const message = _i18n.i18n.translate('data.mgmt.searchSessions.extendModal.extendMessage', {
    defaultMessage: "The search session '{name}' expiration would be extended until {newExpires}.",
    values: {
      name,
      newExpires: newExpiration.toLocaleString()
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: title,
    onCancel: onActionDismiss,
    onConfirm: async () => {
      setIsLoading(true);
      await api.sendExtend(id, `${newExpiration.toISOString()}`);
      setIsLoading(false);
      onActionDismiss();
    },
    confirmButtonText: confirm,
    confirmButtonDisabled: isLoading,
    cancelButtonText: extend,
    defaultFocusedButton: "confirm",
    buttonColor: "primary"
  }, message);
};
const createExtendActionDescriptor = (api, uiSession, core) => ({
  iconType: _extend_session.default,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "data.mgmt.searchSessions.actionExtend",
    defaultMessage: "Extend"
  }),
  onClick: async () => {
    const ref = core.overlays.openModal((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(ExtendConfirm, {
      onActionDismiss: () => ref === null || ref === void 0 ? void 0 : ref.close(),
      searchSession: uiSession,
      api: api
    }), {
      theme$: core.theme.theme$
    }));
    await ref.onClose;
  }
});
exports.createExtendActionDescriptor = createExtendActionDescriptor;