"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ACTION_MULTI_VALUE_CLICK = void 0;
exports.createMultiValueClickActionDefinition = createMultiValueClickActionDefinition;
var _create_filters_from_multi_value_click = require("./filters/create_filters_from_multi_value_click");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_MULTI_VALUE_CLICK = 'ACTION_MULTI_VALUE_CLICK';
exports.ACTION_MULTI_VALUE_CLICK = ACTION_MULTI_VALUE_CLICK;
function createMultiValueClickActionDefinition(getStartServices) {
  return {
    type: ACTION_MULTI_VALUE_CLICK,
    id: ACTION_MULTI_VALUE_CLICK,
    shouldAutoExecute: async () => true,
    isCompatible: async context => {
      const filters = await (0, _create_filters_from_multi_value_click.createFiltersFromMultiValueClickAction)(context.data);
      return Boolean(filters);
    },
    execute: async context => {
      const filter = await (0, _create_filters_from_multi_value_click.createFiltersFromMultiValueClickAction)(context.data);
      getStartServices().filterManager.addFilters(filter);
    }
  };
}