"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findDashboardIdByTitle = findDashboardIdByTitle;
exports.findDashboardsByIds = findDashboardsByIds;
exports.searchDashboards = searchDashboards;
var _dashboard_constants = require("../../../dashboard_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function searchDashboards({
  contentManagement,
  hasNoReference,
  hasReference,
  search,
  size
}) {
  const {
    hits,
    pagination: {
      total
    }
  } = await contentManagement.client.search({
    contentTypeId: _dashboard_constants.DASHBOARD_CONTENT_ID,
    query: {
      text: search ? `${search}*` : undefined,
      limit: size,
      tags: {
        included: (hasReference !== null && hasReference !== void 0 ? hasReference : []).map(({
          id
        }) => id),
        excluded: (hasNoReference !== null && hasNoReference !== void 0 ? hasNoReference : []).map(({
          id
        }) => id)
      }
    }
  });
  return {
    total,
    hits
  };
}
async function findDashboardsByIds(contentManagement, ids) {
  const findPromises = ids.map(id => contentManagement.client.get({
    contentTypeId: _dashboard_constants.DASHBOARD_CONTENT_ID,
    id
  }));
  const results = await Promise.all(findPromises);
  return results.map(result => {
    if (result.item.error) return {
      status: 'error',
      error: result.item.error,
      id: result.item.id
    };
    const {
      attributes,
      id
    } = result.item;
    return {
      id,
      status: 'success',
      attributes
    };
  });
}
async function findDashboardIdByTitle(contentManagement, title) {
  const {
    hits
  } = await contentManagement.client.search({
    contentTypeId: _dashboard_constants.DASHBOARD_CONTENT_ID,
    query: {
      text: title ? `${title}*` : undefined,
      limit: 10
    },
    options: {
      onlyTitle: true
    }
  });
  // The search isn't an exact match, lets see if we can find a single exact match to use
  const matchingDashboards = hits.filter(hit => hit.attributes.title.toLowerCase() === title.toLowerCase());
  if (matchingDashboards.length === 1) {
    return {
      id: matchingDashboards[0].id
    };
  }
}