"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlaceholderEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _ = require(".");
var _plugin_services = require("../services/plugin_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class PlaceholderEmbeddable extends _public2.Embeddable {
  constructor(initialInput, parent) {
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "type", _.PLACEHOLDER_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "node", void 0);
    this.input = initialInput;
  }
  render(node) {
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
    this.node = node;
    const {
      settings: {
        theme: {
          theme$
        }
      }
    } = _plugin_services.pluginServices.getServices();
    const classes = (0, _classnames.default)('embPanel', 'embPanel-isLoading');
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: theme$
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: classes
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      size: "l",
      mono: true
    }))), node);
  }
  reload() {}
}
exports.PlaceholderEmbeddable = PlaceholderEmbeddable;