"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addOrUpdateEmbeddable = addOrUpdateEmbeddable;
exports.replacePanel = replacePanel;
exports.showPlaceholderUntil = showPlaceholderUntil;
var _uuid = require("uuid");
var _panel = require("../../component/panel");
var _placeholder_embeddable = require("../../../placeholder_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function addOrUpdateEmbeddable(type, explicitInput, embeddableId) {
  const idToReplace = embeddableId || explicitInput.id;
  if (idToReplace && this.input.panels[idToReplace]) {
    return this.replacePanel(this.input.panels[idToReplace], {
      type,
      explicitInput: {
        ...explicitInput,
        id: idToReplace
      }
    });
  }
  return this.addNewEmbeddable(type, explicitInput);
}
async function replacePanel(previousPanelState, newPanelState, generateNewId) {
  let panels;
  let panelId;
  if (generateNewId) {
    // replace panel can be called with generateNewId in order to totally destroy and recreate the embeddable
    panelId = (0, _uuid.v4)();
    panels = {
      ...this.input.panels
    };
    delete panels[previousPanelState.explicitInput.id];
    panels[panelId] = {
      ...previousPanelState,
      ...newPanelState,
      gridData: {
        ...previousPanelState.gridData,
        i: panelId
      },
      explicitInput: {
        ...newPanelState.explicitInput,
        id: panelId
      }
    };
  } else {
    // Because the embeddable type can change, we have to operate at the container level here
    panelId = previousPanelState.explicitInput.id;
    panels = {
      ...this.input.panels,
      [panelId]: {
        ...previousPanelState,
        ...newPanelState,
        gridData: {
          ...previousPanelState.gridData
        },
        explicitInput: {
          ...newPanelState.explicitInput,
          id: panelId
        }
      }
    };
  }
  await this.updateInput({
    panels
  });
  return panelId;
}
function showPlaceholderUntil(newStateComplete, placementMethod, placementArgs) {
  const originalPanelState = {
    type: _placeholder_embeddable.PLACEHOLDER_EMBEDDABLE,
    explicitInput: {
      id: (0, _uuid.v4)(),
      disabledActions: ['ACTION_CUSTOMIZE_PANEL', 'CUSTOM_TIME_RANGE', 'clonePanel', 'replacePanel', 'togglePanel']
    }
  };
  const {
    otherPanels,
    newPanel: placeholderPanelState
  } = (0, _panel.createPanelState)(originalPanelState, this.input.panels, placementMethod, placementArgs);
  this.updateInput({
    panels: {
      ...otherPanels,
      [placeholderPanelState.explicitInput.id]: placeholderPanelState
    }
  });

  // wait until the placeholder is ready, then replace it with new panel
  // this is useful as sometimes panels can load faster than the placeholder one (i.e. by value embeddables)
  this.untilEmbeddableLoaded(originalPanelState.explicitInput.id).then(() => newStateComplete).then(async newPanelState => {
    const panelId = await this.replacePanel(placeholderPanelState, newPanelState);
    if (placementArgs !== null && placementArgs !== void 0 && placementArgs.scrollToPanel) {
      this.setScrollToPanelId(panelId);
      this.setHighlightPanelId(panelId);
    }
  });
}