"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FiltersNotificationPopoverContents = FiltersNotificationPopoverContents;
var _react = _interopRequireWildcard(require("react"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-search-plugin/public");
var _react2 = require("@emotion/react");
var _esQuery = require("@kbn/es-query");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function FiltersNotificationPopoverContents({
  context
}) {
  const {
    embeddable
  } = context;
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [filters, setFilters] = (0, _react.useState)([]);
  const [queryString, setQueryString] = (0, _react.useState)('');
  const [queryLanguage, setQueryLanguage] = (0, _react.useState)();
  const dataViews = (0, _react.useMemo)(() => {
    var _embeddable$getRoot;
    return (_embeddable$getRoot = embeddable.getRoot()) === null || _embeddable$getRoot === void 0 ? void 0 : _embeddable$getRoot.getAllDataViews();
  }, [embeddable]);
  (0, _useMount.default)(() => {
    Promise.all([embeddable.getFilters(), embeddable.getQuery()]).then(([embeddableFilters, embeddableQuery]) => {
      setFilters(embeddableFilters);
      if (embeddableQuery) {
        if ((0, _esQuery.isOfQueryType)(embeddableQuery)) {
          setQueryString(embeddableQuery.query);
        } else {
          const language = (0, _esQuery.getAggregateQueryMode)(embeddableQuery);
          setQueryLanguage(language);
          setQueryString(embeddableQuery[language]);
        }
      }
      setIsLoading(false);
    });
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "div",
    css: (0, _react2.css)`
        min-width: 300px;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    isLoading: isLoading,
    lines: 3
  }, queryString !== '' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _dashboard_actions_strings.dashboardFilterNotificationActionStrings.getQueryTitle(),
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: queryLanguage,
    paddingSize: "none",
    transparentBackground: true,
    "aria-labelledby": `${_dashboard_actions_strings.dashboardFilterNotificationActionStrings.getQueryTitle()}: ${queryString}`,
    tabIndex: 0 // focus so that keyboard controls will not skip over the code block
  }, queryString)), filters && filters.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _dashboard_actions_strings.dashboardFilterNotificationActionStrings.getFiltersTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_public.FilterItems, {
    filters: filters,
    indexPatterns: dataViews,
    readOnly: true
  })))));
}