"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyToDashboardAction = exports.ACTION_COPY_TO_DASHBOARD = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _plugin_services = require("../services/plugin_services");
var _copy_to_dashboard_modal = require("./copy_to_dashboard_modal");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _dashboard_container = require("../dashboard_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_COPY_TO_DASHBOARD = 'copyToDashboard';
exports.ACTION_COPY_TO_DASHBOARD = ACTION_COPY_TO_DASHBOARD;
function isDashboard(embeddable) {
  return embeddable.type === _dashboard_container.DASHBOARD_CONTAINER_TYPE;
}
class CopyToDashboardAction {
  constructor(PresentationUtilContext) {
    (0, _defineProperty2.default)(this, "type", ACTION_COPY_TO_DASHBOARD);
    (0, _defineProperty2.default)(this, "id", ACTION_COPY_TO_DASHBOARD);
    (0, _defineProperty2.default)(this, "order", 1);
    (0, _defineProperty2.default)(this, "dashboardCapabilities", void 0);
    (0, _defineProperty2.default)(this, "theme$", void 0);
    (0, _defineProperty2.default)(this, "openModal", void 0);
    this.PresentationUtilContext = PresentationUtilContext;
    ({
      dashboardCapabilities: this.dashboardCapabilities,
      overlays: {
        openModal: this.openModal
      },
      settings: {
        theme: {
          theme$: this.theme$
        }
      }
    } = _plugin_services.pluginServices.getServices());
  }
  getDisplayName({
    embeddable
  }) {
    if (!embeddable.parent || !isDashboard(embeddable.parent)) {
      throw new _public2.IncompatibleActionError();
    }
    return _dashboard_actions_strings.dashboardCopyToDashboardActionStrings.getDisplayName();
  }
  getIconType({
    embeddable
  }) {
    if (!embeddable.parent || !isDashboard(embeddable.parent)) {
      throw new _public2.IncompatibleActionError();
    }
    return 'exit';
  }
  async isCompatible({
    embeddable
  }) {
    const {
      createNew: canCreateNew,
      showWriteControls: canEditExisting
    } = this.dashboardCapabilities;
    return Boolean(embeddable.parent && isDashboard(embeddable.parent) && (canCreateNew || canEditExisting));
  }
  async execute({
    embeddable
  }) {
    if (!embeddable.parent || !isDashboard(embeddable.parent)) {
      throw new _public2.IncompatibleActionError();
    }
    const session = this.openModal((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_copy_to_dashboard_modal.CopyToDashboardModal, {
      PresentationUtilContext: this.PresentationUtilContext,
      closeModal: () => session.close(),
      dashboardId: embeddable.parent.getDashboardSavedObjectId(),
      embeddable: embeddable
    }), {
      theme$: this.theme$
    }), {
      maxWidth: 400,
      'data-test-subj': 'copyToDashboardPanel'
    });
  }
}
exports.CopyToDashboardAction = CopyToDashboardAction;