"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoFollowPatternTable = void 0;
var _reactRedux = require("react-redux");
var _constants = require("../../../../../constants");
var _actions = require("../../../../../store/actions");
var _selectors = require("../../../../../store/selectors");
var _auto_follow_pattern_table = require("./auto_follow_pattern_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scope = _constants.SECTIONS.AUTO_FOLLOW_PATTERN;
const mapStateToProps = state => ({
  apiStatusDelete: (0, _selectors.getApiStatus)(`${scope}-delete`)(state)
});
const mapDispatchToProps = dispatch => ({
  selectAutoFollowPattern: name => dispatch((0, _actions.selectDetailAutoFollowPattern)(name)),
  pauseAutoFollowPattern: name => dispatch((0, _actions.pauseAutoFollowPattern)(name)),
  resumeAutoFollowPattern: name => dispatch((0, _actions.resumeAutoFollowPattern)(name))
});
const AutoFollowPatternTable = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_auto_follow_pattern_table.AutoFollowPatternTable);
exports.AutoFollowPatternTable = AutoFollowPatternTable;