"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoFollowPatternEdit = void 0;
var _reactRedux = require("react-redux");
var _constants = require("../../constants");
var _selectors = require("../../store/selectors");
var _actions = require("../../store/actions");
var _auto_follow_pattern_edit = require("./auto_follow_pattern_edit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scope = _constants.SECTIONS.AUTO_FOLLOW_PATTERN;
const mapStateToProps = state => ({
  apiStatus: {
    get: (0, _selectors.getApiStatus)(`${scope}-get`)(state),
    save: (0, _selectors.getApiStatus)(`${scope}-save`)(state)
  },
  apiError: {
    get: (0, _selectors.getApiError)(`${scope}-get`)(state),
    save: (0, _selectors.getApiError)(`${scope}-save`)(state)
  },
  autoFollowPatternId: (0, _selectors.getSelectedAutoFollowPatternId)('edit')(state),
  autoFollowPattern: (0, _selectors.getSelectedAutoFollowPattern)('edit')(state)
});
const mapDispatchToProps = dispatch => ({
  getAutoFollowPattern: id => dispatch((0, _actions.getAutoFollowPattern)(id)),
  selectAutoFollowPattern: id => dispatch((0, _actions.selectEditAutoFollowPattern)(id)),
  saveAutoFollowPattern: (id, autoFollowPattern) => {
    // Strip out errors.
    const {
      active,
      remoteCluster,
      leaderIndexPatterns,
      followIndexPattern
    } = autoFollowPattern;
    dispatch((0, _actions.saveAutoFollowPattern)(id, {
      active,
      remoteCluster,
      leaderIndexPatterns,
      followIndexPattern
    }, true));
  },
  clearApiError: () => {
    dispatch((0, _actions.clearApiError)(`${scope}-get`));
    dispatch((0, _actions.clearApiError)(`${scope}-save`));
  }
});
const AutoFollowPatternEdit = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_auto_follow_pattern_edit.AutoFollowPatternEdit);
exports.AutoFollowPatternEdit = AutoFollowPatternEdit;