"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deterministicallyRegenerateObjectId = deterministicallyRegenerateObjectId;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Deterministically regenerates a saved object's ID based upon it's current namespace, type, and ID. This ensures that we can regenerate
 * any existing object IDs without worrying about collisions if two objects that exist in different namespaces share an ID. It also ensures
 * that we can later regenerate any inbound object references to match.
 *
 * @note This is only intended to be used when single-namespace object types are converted into multi-namespace object types.
 * @internal
 */
function deterministicallyRegenerateObjectId(namespace, type, id) {
  return (0, _uuid.v5)(`${namespace}:${type}:${id}`, _uuid.v5.DNS); // the uuidv5 namespace constant (uuidv5.DNS) is arbitrary
}