"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkTargetMappings = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _build_active_mappings = require("../core/build_active_mappings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const checkTargetMappings = ({
  indexTypes,
  actualMappings,
  expectedMappings
}) => async () => {
  var _actualMappings$_meta;
  if (!(actualMappings !== null && actualMappings !== void 0 && (_actualMappings$_meta = actualMappings._meta) !== null && _actualMappings$_meta !== void 0 && _actualMappings$_meta.migrationMappingPropertyHashes) || actualMappings.dynamic !== expectedMappings.dynamic) {
    return Either.left({
      type: 'actual_mappings_incomplete'
    });
  }
  const updatedHashes = (0, _build_active_mappings.getUpdatedHashes)({
    actual: actualMappings,
    expected: expectedMappings
  });
  if (updatedHashes.length) {
    const updatedTypes = updatedHashes.filter(field => indexTypes.includes(field));
    const updatedRootFields = updatedHashes.filter(field => !indexTypes.includes(field));
    return Either.left({
      type: 'compared_mappings_changed',
      updatedRootFields,
      updatedTypes
    });
  } else {
    return Either.right({
      type: 'compared_mappings_match'
    });
  }
};
exports.checkTargetMappings = checkTargetMappings;