"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventLoopUtilizationMonitor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _perf_hooks = require("perf_hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class EventLoopUtilizationMonitor {
  /**
   * Creating a new instance of EventLoopUtilizationMonitor will capture the
   * current ELU to use as a point of comparison against the first call to
   * `collect`.
   */
  constructor() {
    (0, _defineProperty2.default)(this, "elu", void 0);
    this.elu = _perf_hooks.performance.eventLoopUtilization();
  }

  /**
   * Get ELU between now and last time the ELU was reset.
   */
  collect() {
    const {
      active,
      idle,
      utilization
    } = _perf_hooks.performance.eventLoopUtilization(this.elu);
    return {
      active,
      idle,
      utilization
    };
  }

  /**
   * Resets the ELU to now. Will be used to calculate the diff on the next call to `collect`.
   */
  reset() {
    this.elu = _perf_hooks.performance.eventLoopUtilization();
  }
}
exports.EventLoopUtilizationMonitor = EventLoopUtilizationMonitor;