"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValidationAggregationBuilder = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Validation aggregations
 */
const getValidationAggregationBuilder = () => ({
  buildAggregation: ({
    selectedOptions,
    fieldName
  }) => {
    let selectedOptionsFilters;
    if (selectedOptions) {
      selectedOptionsFilters = selectedOptions.reduce((acc, currentOption) => {
        acc[currentOption] = {
          match: {
            [fieldName]: currentOption
          }
        };
        return acc;
      }, {});
    }
    return selectedOptionsFilters && !(0, _lodash.isEmpty)(selectedOptionsFilters) ? {
      filters: {
        filters: selectedOptionsFilters
      }
    } : undefined;
  },
  parse: rawEsResult => {
    const rawInvalidSuggestions = (0, _lodash.get)(rawEsResult, 'aggregations.validation.buckets');
    return rawInvalidSuggestions && !(0, _lodash.isEmpty)(rawInvalidSuggestions) ? Object.keys(rawInvalidSuggestions).filter(key => rawInvalidSuggestions[key].doc_count === 0) : [];
  }
});
exports.getValidationAggregationBuilder = getValidationAggregationBuilder;