"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.optionsListReducers = exports.getDefaultComponentState = void 0;
var _ip_search = require("../../common/options_list/ip_search");
var _suggestions_sorting = require("../../common/options_list/suggestions_sorting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getDefaultComponentState = () => ({
  popoverOpen: false,
  allowExpensiveQueries: true,
  searchString: {
    value: '',
    valid: true
  }
});
exports.getDefaultComponentState = getDefaultComponentState;
const optionsListReducers = {
  deselectOption: (state, action) => {
    if (!state.explicitInput.selectedOptions) return;
    const itemIndex = state.explicitInput.selectedOptions.indexOf(action.payload);
    if (itemIndex !== -1) {
      const newSelections = [...state.explicitInput.selectedOptions];
      newSelections.splice(itemIndex, 1);
      state.explicitInput.selectedOptions = newSelections;
    }
  },
  setSearchString: (state, action) => {
    var _state$componentState;
    state.componentState.searchString.value = action.payload;
    if (action.payload !== '' &&
    // empty string search is never invalid
    ((_state$componentState = state.componentState.field) === null || _state$componentState === void 0 ? void 0 : _state$componentState.type) === 'ip' // only IP searches can currently be invalid
    ) {
      state.componentState.searchString.valid = (0, _ip_search.getIpRangeQuery)(action.payload).validSearch;
    }
  },
  setAllowExpensiveQueries: (state, action) => {
    state.componentState.allowExpensiveQueries = action.payload;
  },
  setPopoverOpen: (state, action) => {
    state.componentState.popoverOpen = action.payload;
  },
  setSort: (state, action) => {
    var _state$explicitInput$;
    state.explicitInput.sort = {
      ...((_state$explicitInput$ = state.explicitInput.sort) !== null && _state$explicitInput$ !== void 0 ? _state$explicitInput$ : _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT),
      ...action.payload
    };
  },
  selectExists: (state, action) => {
    if (action.payload) {
      state.explicitInput.existsSelected = true;
      state.explicitInput.selectedOptions = [];
    } else {
      state.explicitInput.existsSelected = false;
    }
  },
  selectOption: (state, action) => {
    var _state$explicitInput$2;
    if (!state.explicitInput.selectedOptions) state.explicitInput.selectedOptions = [];
    if (state.explicitInput.existsSelected) state.explicitInput.existsSelected = false;
    (_state$explicitInput$2 = state.explicitInput.selectedOptions) === null || _state$explicitInput$2 === void 0 ? void 0 : _state$explicitInput$2.push(action.payload);
  },
  replaceSelection: (state, action) => {
    state.explicitInput.selectedOptions = [action.payload];
    if (state.explicitInput.existsSelected) state.explicitInput.existsSelected = false;
  },
  clearSelections: state => {
    if (state.explicitInput.existsSelected) state.explicitInput.existsSelected = false;
    if (state.explicitInput.selectedOptions) state.explicitInput.selectedOptions = [];
  },
  setExclude: (state, action) => {
    state.explicitInput.exclude = action.payload;
  },
  clearValidAndInvalidSelections: state => {
    state.componentState.invalidSelections = [];
    state.componentState.validSelections = [];
  },
  setValidAndInvalidSelections: (state, action) => {
    const {
      invalidSelections,
      validSelections
    } = action.payload;
    state.componentState.invalidSelections = invalidSelections;
    state.componentState.validSelections = validSelections;
  },
  setErrorMessage: (state, action) => {
    state.componentState.error = action.payload;
  },
  setLoading: (state, action) => {
    state.output.loading = action.payload;
  },
  setField: (state, action) => {
    state.componentState.field = action.payload;
  },
  updateQueryResults: (state, action) => {
    var _state$componentState2;
    state.componentState = {
      ...((_state$componentState2 = state.componentState) !== null && _state$componentState2 !== void 0 ? _state$componentState2 : {}),
      ...action.payload
    };
  },
  publishFilters: (state, action) => {
    state.output.filters = action.payload;
  },
  setDataViewId: (state, action) => {
    state.output.dataViewId = action.payload;
  }
};
exports.optionsListReducers = optionsListReducers;