"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOptionsList = exports.OptionsListEmbeddableContext = exports.OptionsListEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _react = _interopRequireWildcard(require("react"));
var _operators = require("rxjs/operators");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _ = require("../..");
var _services = require("../../services");
var _options_list_control = require("../components/options_list_control");
var _types = require("../types");
var _options_list_reducers = require("../options_list_reducers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const diffDataFetchProps = (last, current) => {
  if (!current || !last) return false;
  const {
    filters: currentFilters,
    ...currentWithoutFilters
  } = current;
  const {
    filters: lastFilters,
    ...lastWithoutFilters
  } = last;
  if (!(0, _fastDeepEqual.default)(currentWithoutFilters, lastWithoutFilters)) return false;
  if (!(0, _esQuery.compareFilters)(lastFilters !== null && lastFilters !== void 0 ? lastFilters : [], currentFilters !== null && currentFilters !== void 0 ? currentFilters : [], _esQuery.COMPARE_ALL_OPTIONS)) return false;
  return true;
};
const OptionsListEmbeddableContext = /*#__PURE__*/(0, _react.createContext)(null);
exports.OptionsListEmbeddableContext = OptionsListEmbeddableContext;
const useOptionsList = () => {
  const optionsList = (0, _react.useContext)(OptionsListEmbeddableContext);
  if (optionsList == null) {
    throw new Error('useOptionsList must be used inside OptionsListEmbeddableContext.');
  }
  return optionsList;
};
exports.useOptionsList = useOptionsList;
class OptionsListEmbeddable extends _public.Embeddable {
  // Controls services

  // Internal data fetching state for this input control.

  // state management

  constructor(reduxToolsPackage, input, output, parent) {
    super(input, output, parent);

    // Destructure controls services
    (0, _defineProperty2.default)(this, "type", _.OPTIONS_LIST_CONTROL);
    (0, _defineProperty2.default)(this, "deferEmbeddableLoad", true);
    (0, _defineProperty2.default)(this, "subscriptions", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "dataViewsService", void 0);
    (0, _defineProperty2.default)(this, "optionsListService", void 0);
    (0, _defineProperty2.default)(this, "typeaheadSubject", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "loadMoreSubject", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "abortController", void 0);
    (0, _defineProperty2.default)(this, "dataView", void 0);
    (0, _defineProperty2.default)(this, "field", void 0);
    (0, _defineProperty2.default)(this, "select", void 0);
    (0, _defineProperty2.default)(this, "getState", void 0);
    (0, _defineProperty2.default)(this, "dispatch", void 0);
    (0, _defineProperty2.default)(this, "onStateChange", void 0);
    (0, _defineProperty2.default)(this, "cleanupStateTools", void 0);
    (0, _defineProperty2.default)(this, "initialize", async () => {
      const {
        selectedOptions: initialSelectedOptions
      } = this.getInput();
      if (!initialSelectedOptions) this.setInitializationFinished();
      this.dispatch.setAllowExpensiveQueries(await this.optionsListService.getAllowExpensiveQueries());
      this.runOptionsListQuery().then(async () => {
        if (initialSelectedOptions) {
          await this.buildFilter();
          this.setInitializationFinished();
        }
        this.setupSubscriptions();
      });
    });
    (0, _defineProperty2.default)(this, "setupSubscriptions", () => {
      const dataFetchPipe = this.getInput$().pipe((0, _operators.map)(newInput => {
        var _newInput$ignoreParen;
        return {
          validate: !Boolean((_newInput$ignoreParen = newInput.ignoreParentSettings) === null || _newInput$ignoreParen === void 0 ? void 0 : _newInput$ignoreParen.ignoreValidations),
          lastReloadRequestTime: newInput.lastReloadRequestTime,
          existsSelected: newInput.existsSelected,
          searchTechnique: newInput.searchTechnique,
          dataViewId: newInput.dataViewId,
          fieldName: newInput.fieldName,
          timeRange: newInput.timeRange,
          timeslice: newInput.timeslice,
          exclude: newInput.exclude,
          filters: newInput.filters,
          query: newInput.query,
          sort: newInput.sort
        };
      }), (0, _operators.distinctUntilChanged)(diffDataFetchProps));

      // debounce typeahead pipe to slow down search string related queries
      const typeaheadPipe = this.typeaheadSubject.pipe((0, _operators.debounceTime)(100));
      const loadMorePipe = this.loadMoreSubject.pipe((0, _operators.debounceTime)(100));

      // fetch available options when input changes or when search string has changed
      this.subscriptions.add((0, _rxjs.merge)(dataFetchPipe, typeaheadPipe).pipe((0, _operators.skip)(1)) // Skip the first input update because options list query will be run by initialize.
      .subscribe(() => {
        this.runOptionsListQuery();
      }));

      // fetch more options when reaching the bottom of the available options
      this.subscriptions.add(loadMorePipe.subscribe(size => {
        this.runOptionsListQuery(size);
      }));

      /**
       * when input selectedOptions changes, check all selectedOptions against the latest value of invalidSelections, and publish filter
       **/
      this.subscriptions.add(this.getInput$().pipe((0, _operators.distinctUntilChanged)((a, b) => a.exclude === b.exclude && a.existsSelected === b.existsSelected && (0, _lodash.isEqual)(a.selectedOptions, b.selectedOptions))).subscribe(async ({
        selectedOptions: newSelectedOptions
      }) => {
        if (!newSelectedOptions || (0, _lodash.isEmpty)(newSelectedOptions)) {
          this.dispatch.clearValidAndInvalidSelections({});
        } else {
          var _this$getState$compon;
          const {
            invalidSelections
          } = (_this$getState$compon = this.getState().componentState) !== null && _this$getState$compon !== void 0 ? _this$getState$compon : {};
          const newValidSelections = [];
          const newInvalidSelections = [];
          for (const selectedOption of newSelectedOptions) {
            if (invalidSelections !== null && invalidSelections !== void 0 && invalidSelections.includes(selectedOption)) {
              newInvalidSelections.push(selectedOption);
              continue;
            }
            newValidSelections.push(selectedOption);
          }
          this.dispatch.setValidAndInvalidSelections({
            validSelections: newValidSelections,
            invalidSelections: newInvalidSelections
          });
        }
        const newFilters = await this.buildFilter();
        this.dispatch.publishFilters(newFilters);
      }));
    });
    (0, _defineProperty2.default)(this, "getCurrentDataViewAndField", async () => {
      const {
        explicitInput: {
          dataViewId,
          fieldName
        }
      } = this.getState();
      if (!this.dataView || this.dataView.id !== dataViewId) {
        var _this$dataView;
        try {
          this.dataView = await this.dataViewsService.get(dataViewId);
          if (!this.dataView) throw new Error(_i18n.i18n.translate('controls.optionsList.errors.dataViewNotFound', {
            defaultMessage: 'Could not locate data view: {dataViewId}',
            values: {
              dataViewId
            }
          }));
        } catch (e) {
          this.dispatch.setErrorMessage(e.message);
        }
        this.dispatch.setDataViewId((_this$dataView = this.dataView) === null || _this$dataView === void 0 ? void 0 : _this$dataView.id);
      }
      if (this.dataView && (!this.field || this.field.name !== fieldName)) {
        try {
          const originalField = this.dataView.getFieldByName(fieldName);
          if (!originalField) {
            throw new Error(_i18n.i18n.translate('controls.optionsList.errors.fieldNotFound', {
              defaultMessage: 'Could not locate field: {fieldName}',
              values: {
                fieldName
              }
            }));
          }
          this.field = originalField.toSpec();
        } catch (e) {
          this.dispatch.setErrorMessage(e.message);
        }
        this.dispatch.setField(this.field);
      }
      return {
        dataView: this.dataView,
        field: this.field
      };
    });
    (0, _defineProperty2.default)(this, "runOptionsListQuery", async (size = _types.MIN_OPTIONS_LIST_REQUEST_SIZE) => {
      var _this$field;
      const previousFieldName = (_this$field = this.field) === null || _this$field === void 0 ? void 0 : _this$field.name;
      const {
        dataView,
        field
      } = await this.getCurrentDataViewAndField();
      if (!dataView || !field) return;
      if (previousFieldName && field.name !== previousFieldName) {
        this.dispatch.setSearchString('');
      }
      const {
        componentState: {
          searchString,
          allowExpensiveQueries
        },
        explicitInput: {
          selectedOptions,
          runPastTimeout,
          existsSelected,
          sort,
          searchTechnique
        }
      } = this.getState();
      this.dispatch.setLoading(true);
      if (searchString.valid) {
        // need to get filters, query, ignoreParentSettings, and timeRange from input for inheritance
        const {
          ignoreParentSettings,
          filters,
          query,
          timeRange: globalTimeRange,
          timeslice
        } = this.getInput();
        if (this.abortController) this.abortController.abort();
        this.abortController = new AbortController();
        const timeRange = timeslice !== undefined ? {
          from: new Date(timeslice[0]).toISOString(),
          to: new Date(timeslice[1]).toISOString(),
          mode: 'absolute'
        } : globalTimeRange;
        const response = await this.optionsListService.runOptionsListRequest({
          sort,
          size,
          field,
          query,
          filters,
          dataView,
          timeRange,
          searchTechnique,
          runPastTimeout,
          selectedOptions,
          allowExpensiveQueries,
          searchString: searchString.value
        }, this.abortController.signal);
        if (this.optionsListService.optionsListResponseWasFailure(response)) {
          if (response.error === 'aborted') {
            // This prevents an aborted request (which can happen, for example, when a user types a search string too quickly)
            // from prematurely setting loading to `false` and updating the suggestions to show "No results"
            return;
          }
          this.dispatch.setErrorMessage(response.error.message);
          return;
        }
        const {
          suggestions,
          invalidSelections,
          totalCardinality
        } = response;
        if (!selectedOptions && !existsSelected || (0, _lodash.isEmpty)(invalidSelections) || ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreValidations) {
          this.dispatch.updateQueryResults({
            availableOptions: suggestions,
            invalidSelections: undefined,
            validSelections: selectedOptions,
            totalCardinality
          });
        } else {
          const valid = [];
          const invalid = [];
          for (const selectedOption of selectedOptions !== null && selectedOptions !== void 0 ? selectedOptions : []) {
            if (invalidSelections !== null && invalidSelections !== void 0 && invalidSelections.includes(selectedOption)) invalid.push(selectedOption);else valid.push(selectedOption);
          }
          this.dispatch.updateQueryResults({
            availableOptions: suggestions,
            invalidSelections: invalid,
            validSelections: valid,
            totalCardinality
          });
        }

        // publish filter
        const newFilters = await this.buildFilter();
        (0, _reactRedux.batch)(() => {
          this.dispatch.setErrorMessage(undefined);
          this.dispatch.setLoading(false);
          this.dispatch.publishFilters(newFilters);
        });
      } else {
        (0, _reactRedux.batch)(() => {
          this.dispatch.setErrorMessage(undefined);
          this.dispatch.updateQueryResults({
            availableOptions: []
          });
          this.dispatch.setLoading(false);
        });
      }
    });
    (0, _defineProperty2.default)(this, "buildFilter", async () => {
      var _this$getState$compon2, _this$getState$explic;
      const {
        validSelections
      } = (_this$getState$compon2 = this.getState().componentState) !== null && _this$getState$compon2 !== void 0 ? _this$getState$compon2 : {};
      const {
        existsSelected
      } = (_this$getState$explic = this.getState().explicitInput) !== null && _this$getState$explic !== void 0 ? _this$getState$explic : {};
      const {
        exclude
      } = this.getInput();
      if ((!validSelections || (0, _lodash.isEmpty)(validSelections)) && !existsSelected) {
        return [];
      }
      const {
        dataView,
        field
      } = await this.getCurrentDataViewAndField();
      if (!dataView || !field) return;
      let newFilter;
      if (existsSelected) {
        newFilter = (0, _esQuery.buildExistsFilter)(field, dataView);
      } else if (validSelections) {
        if (validSelections.length === 1) {
          newFilter = (0, _esQuery.buildPhraseFilter)(field, validSelections[0], dataView);
        } else {
          newFilter = (0, _esQuery.buildPhrasesFilter)(field, validSelections, dataView);
        }
      }
      if (!newFilter) return [];
      newFilter.meta.key = field === null || field === void 0 ? void 0 : field.name;
      if (exclude) newFilter.meta.negate = true;
      return [newFilter];
    });
    (0, _defineProperty2.default)(this, "reload", () => {
      // clear cache when reload is requested
      this.optionsListService.clearOptionsListCache();
      this.runOptionsListQuery();
    });
    (0, _defineProperty2.default)(this, "destroy", () => {
      var _this$abortController;
      super.destroy();
      this.cleanupStateTools();
      (_this$abortController = this.abortController) === null || _this$abortController === void 0 ? void 0 : _this$abortController.abort();
      this.subscriptions.unsubscribe();
      if (this.node) _reactDom.default.unmountComponentAtNode(this.node);
    });
    (0, _defineProperty2.default)(this, "render", node => {
      if (this.node) {
        _reactDom.default.unmountComponentAtNode(this.node);
      }
      this.node = node;
      _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
        theme$: _services.pluginServices.getServices().theme.theme$
      }, /*#__PURE__*/_react.default.createElement(OptionsListEmbeddableContext.Provider, {
        value: this
      }, /*#__PURE__*/_react.default.createElement(_options_list_control.OptionsListControl, {
        typeaheadSubject: this.typeaheadSubject,
        loadMoreSubject: this.loadMoreSubject
      }))), node);
    });
    ({
      dataViews: this.dataViewsService,
      optionsList: this.optionsListService
    } = _services.pluginServices.getServices());
    this.typeaheadSubject = new _rxjs.Subject();
    this.loadMoreSubject = new _rxjs.Subject();

    // build redux embeddable tools
    const reduxEmbeddableTools = reduxToolsPackage.createReduxEmbeddableTools({
      embeddable: this,
      reducers: _options_list_reducers.optionsListReducers,
      initialComponentState: (0, _options_list_reducers.getDefaultComponentState)()
    });
    this.select = reduxEmbeddableTools.select;
    this.getState = reduxEmbeddableTools.getState;
    this.dispatch = reduxEmbeddableTools.dispatch;
    this.cleanupStateTools = reduxEmbeddableTools.cleanup;
    this.onStateChange = reduxEmbeddableTools.onStateChange;
    this.initialize();
  }
  clearSelections() {
    this.dispatch.clearSelections({});
  }
  isChained() {
    return true;
  }
}
exports.OptionsListEmbeddable = OptionsListEmbeddable;