"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlGroupStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ControlGroupStrings = {
  emptyState: {
    getBadge: () => _i18n.i18n.translate('controls.controlGroup.emptyState.badgeText', {
      defaultMessage: 'New'
    }),
    getCallToAction: () => _i18n.i18n.translate('controls.controlGroup.emptyState.callToAction', {
      defaultMessage: 'Filtering your data just got better with Controls, letting you display only the data you want to explore.'
    }),
    getAddControlButtonTitle: () => _i18n.i18n.translate('controls.controlGroup.emptyState.addControlButtonTitle', {
      defaultMessage: 'Add control'
    }),
    getTwoLineLoadingTitle: () => _i18n.i18n.translate('controls.controlGroup.emptyState.twoLineLoadingTitle', {
      defaultMessage: '...'
    }),
    getDismissButton: () => _i18n.i18n.translate('controls.controlGroup.emptyState.dismissButton', {
      defaultMessage: 'Dismiss'
    })
  },
  manageControl: {
    getFlyoutCreateTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.createFlyoutTitle', {
      defaultMessage: 'Create control'
    }),
    getFlyoutEditTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.editFlyoutTitle', {
      defaultMessage: 'Edit control'
    }),
    dataSource: {
      getFormGroupTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.formGroupTitle', {
        defaultMessage: 'Data source'
      }),
      getFormGroupDescription: () => _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.formGroupDescription', {
        defaultMessage: 'Select the data view and field that you want to create a control for.'
      }),
      getSelectDataViewMessage: () => _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.selectDataViewMessage', {
        defaultMessage: 'Please select a data view'
      }),
      getDataViewTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.dataViewTitle', {
        defaultMessage: 'Data view'
      }),
      noControlTypeMessage: () => _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.noControlTypeMessage', {
        defaultMessage: 'No field selected yet'
      }),
      getFieldTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.fieldTitle', {
        defaultMessage: 'Field'
      }),
      getControlTypeTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.dataSource.controlTypesTitle', {
        defaultMessage: 'Control type'
      })
    },
    displaySettings: {
      getFormGroupTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.displaySettings.formGroupTitle', {
        defaultMessage: 'Display settings'
      }),
      getFormGroupDescription: () => _i18n.i18n.translate('controls.controlGroup.manageControl.displaySettings.formGroupDescription', {
        defaultMessage: 'Change how the control appears on your dashboard.'
      }),
      getTitleInputTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.displaySettings.titleInputTitle', {
        defaultMessage: 'Label'
      }),
      getWidthInputTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.displaySettings.widthInputTitle', {
        defaultMessage: 'Minimum width'
      }),
      getGrowSwitchTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.displaySettings.growSwitchTitle', {
        defaultMessage: 'Expand width to fit available space'
      })
    },
    controlTypeSettings: {
      getFormGroupTitle: type => _i18n.i18n.translate('controls.controlGroup.manageControl.controlTypeSettings.formGroupTitle', {
        defaultMessage: '{controlType} settings',
        values: {
          controlType: type
        }
      }),
      getFormGroupDescription: type => _i18n.i18n.translate('controls.controlGroup.manageControl.controlTypeSettings.formGroupDescription', {
        defaultMessage: 'Custom settings for your {controlType} control.',
        values: {
          controlType: type.toLocaleLowerCase()
        }
      })
    },
    getSaveChangesTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.saveChangesTitle', {
      defaultMessage: 'Save and close'
    }),
    getCancelTitle: () => _i18n.i18n.translate('controls.controlGroup.manageControl.cancelTitle', {
      defaultMessage: 'Cancel'
    })
  },
  management: {
    getAddControlTitle: () => _i18n.i18n.translate('controls.controlGroup.management.addControl', {
      defaultMessage: 'Add control'
    }),
    getFlyoutTitle: () => _i18n.i18n.translate('controls.controlGroup.management.flyoutTitle', {
      defaultMessage: 'Control settings'
    }),
    getDeleteButtonTitle: () => _i18n.i18n.translate('controls.controlGroup.management.delete', {
      defaultMessage: 'Delete control'
    }),
    getDeleteAllButtonTitle: () => _i18n.i18n.translate('controls.controlGroup.management.deleteAll', {
      defaultMessage: 'Delete all'
    }),
    controlWidth: {
      getWidthSwitchLegend: () => _i18n.i18n.translate('controls.controlGroup.management.layout.controlWidthLegend', {
        defaultMessage: 'Change control size'
      }),
      getAutoWidthTitle: () => _i18n.i18n.translate('controls.controlGroup.management.layout.auto', {
        defaultMessage: 'Auto'
      }),
      getSmallWidthTitle: () => _i18n.i18n.translate('controls.controlGroup.management.layout.small', {
        defaultMessage: 'Small'
      }),
      getMediumWidthTitle: () => _i18n.i18n.translate('controls.controlGroup.management.layout.medium', {
        defaultMessage: 'Medium'
      }),
      getLargeWidthTitle: () => _i18n.i18n.translate('controls.controlGroup.management.layout.large', {
        defaultMessage: 'Large'
      })
    },
    labelPosition: {
      getLabelPositionTitle: () => _i18n.i18n.translate('controls.controlGroup.management.labelPosition.title', {
        defaultMessage: 'Label position'
      }),
      getLabelPositionLegend: () => _i18n.i18n.translate('controls.controlGroup.management.labelPosition.designSwitchLegend', {
        defaultMessage: 'Switch label position between inline and above'
      }),
      getInlineTitle: () => _i18n.i18n.translate('controls.controlGroup.management.labelPosition.inline', {
        defaultMessage: 'Inline'
      }),
      getAboveTitle: () => _i18n.i18n.translate('controls.controlGroup.management.labelPosition.above', {
        defaultMessage: 'Above'
      })
    },
    deleteControls: {
      getDeleteAllTitle: () => _i18n.i18n.translate('controls.controlGroup.management.delete.deleteAllTitle', {
        defaultMessage: 'Delete all controls?'
      }),
      getDeleteTitle: () => _i18n.i18n.translate('controls.controlGroup.management.delete.deleteTitle', {
        defaultMessage: 'Delete control?'
      }),
      getSubtitle: () => _i18n.i18n.translate('controls.controlGroup.management.delete.sub', {
        defaultMessage: 'Controls are not recoverable once removed.'
      }),
      getConfirm: () => _i18n.i18n.translate('controls.controlGroup.management.delete.confirm', {
        defaultMessage: 'Delete'
      }),
      getCancel: () => _i18n.i18n.translate('controls.controlGroup.management.delete.cancel', {
        defaultMessage: 'Cancel'
      })
    },
    discardChanges: {
      getTitle: () => _i18n.i18n.translate('controls.controlGroup.management.discard.title', {
        defaultMessage: 'Discard changes?'
      }),
      getSubtitle: () => _i18n.i18n.translate('controls.controlGroup.management.discard.sub', {
        defaultMessage: `Changes that you've made to this control will be discarded, are you sure you want to continue?`
      }),
      getConfirm: () => _i18n.i18n.translate('controls.controlGroup.management.discard.confirm', {
        defaultMessage: 'Discard changes'
      }),
      getCancel: () => _i18n.i18n.translate('controls.controlGroup.management.discard.cancel', {
        defaultMessage: 'Cancel'
      })
    },
    discardNewControl: {
      getTitle: () => _i18n.i18n.translate('controls.controlGroup.management.deleteNew.title', {
        defaultMessage: 'Discard new control'
      }),
      getSubtitle: () => _i18n.i18n.translate('controls.controlGroup.management.deleteNew.sub', {
        defaultMessage: `Changes that you've made to this control will be discarded, are you sure you want to continue?`
      }),
      getConfirm: () => _i18n.i18n.translate('controls.controlGroup.management.deleteNew.confirm', {
        defaultMessage: 'Discard control'
      }),
      getCancel: () => _i18n.i18n.translate('controls.controlGroup.management.deleteNew.cancel', {
        defaultMessage: 'Cancel'
      })
    },
    validateSelections: {
      getValidateSelectionsTitle: () => _i18n.i18n.translate('controls.controlGroup.management.validate.title', {
        defaultMessage: 'Validate user selections'
      }),
      getValidateSelectionsSubTitle: () => _i18n.i18n.translate('controls.controlGroup.management.validate.subtitle', {
        defaultMessage: 'Automatically ignore any control selection that would result in no data.'
      })
    },
    controlChaining: {
      getHierarchyTitle: () => _i18n.i18n.translate('controls.controlGroup.management.hierarchy.title', {
        defaultMessage: 'Chain controls'
      }),
      getHierarchySubTitle: () => _i18n.i18n.translate('controls.controlGroup.management.hierarchy.subtitle', {
        defaultMessage: 'Selections in one control narrow down available options in the next. Controls are chained from left to right.'
      })
    },
    querySync: {
      getQuerySettingsTitle: () => _i18n.i18n.translate('controls.controlGroup.management.query.searchSettingsTitle', {
        defaultMessage: 'Sync with query bar'
      }),
      getQuerySettingsSubtitle: () => _i18n.i18n.translate('controls.controlGroup.management.query.useAllSearchSettingsTitle', {
        defaultMessage: 'Keeps the control group in sync with the query bar by applying time range, filter pills, and queries from the query bar'
      }),
      getAdvancedSettingsTitle: () => _i18n.i18n.translate('controls.controlGroup.management.query.advancedSettings', {
        defaultMessage: 'Advanced'
      }),
      getIgnoreTimerangeTitle: () => _i18n.i18n.translate('controls.controlGroup.management.query.ignoreTimerange', {
        defaultMessage: 'Ignore timerange'
      }),
      getIgnoreQueryTitle: () => _i18n.i18n.translate('controls.controlGroup.management.query.ignoreQuery', {
        defaultMessage: 'Ignore query bar'
      }),
      getIgnoreFilterPillsTitle: () => _i18n.i18n.translate('controls.controlGroup.management.query.ignoreFilterPills', {
        defaultMessage: 'Ignore filter pills'
      })
    }
  },
  floatingActions: {
    getEditButtonTitle: () => _i18n.i18n.translate('controls.controlGroup.floatingActions.editTitle', {
      defaultMessage: 'Edit'
    }),
    getRemoveButtonTitle: () => _i18n.i18n.translate('controls.controlGroup.floatingActions.removeTitle', {
      defaultMessage: 'Delete'
    }),
    getClearButtonTitle: () => _i18n.i18n.translate('controls.controlGroup.floatingActions.clearTitle', {
      defaultMessage: 'Clear'
    })
  },
  ariaActions: {
    getMoveControlButtonAction: controlTitle => _i18n.i18n.translate('controls.controlGroup.ariaActions.moveControlButtonAction', {
      defaultMessage: 'Move control {controlTitle}',
      values: {
        controlTitle: controlTitle !== null && controlTitle !== void 0 ? controlTitle : ''
      }
    })
  }
};
exports.ControlGroupStrings = ControlGroupStrings;