"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SortableControl = exports.ControlClone = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classnames = _interopRequireDefault(require("classnames"));
var _utilities = require("@dnd-kit/utilities");
var _sortable = require("@dnd-kit/sortable");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _control_group_strings = require("../control_group_strings");
var _control_frame_component = require("./control_frame_component");
var _control_group_container = require("../embeddable/control_group_container");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * A sortable wrapper around the generic control frame.
 */
const SortableControl = frameProps => {
  const {
    embeddableId,
    isEditable
  } = frameProps;
  const {
    over,
    listeners,
    isSorting,
    transform,
    transition,
    attributes,
    isDragging,
    setNodeRef
  } = (0, _sortable.useSortable)({
    id: embeddableId,
    animateLayoutChanges: () => true,
    disabled: !isEditable
  });
  const sortableFrameProps = {
    ...frameProps,
    dragInfo: {
      ...frameProps.dragInfo,
      isOver: (over === null || over === void 0 ? void 0 : over.id) === embeddableId,
      isDragging
    }
  };
  return /*#__PURE__*/_react.default.createElement(SortableControlInner, (0, _extends2.default)({
    key: embeddableId,
    ref: setNodeRef
  }, sortableFrameProps, attributes, listeners, {
    style: {
      transition: transition !== null && transition !== void 0 ? transition : undefined,
      transform: isSorting ? undefined : _utilities.CSS.Translate.toString(transform)
    }
  }));
};
exports.SortableControl = SortableControl;
const SortableControlInner = /*#__PURE__*/(0, _react.forwardRef)(({
  embeddableId,
  embeddableType,
  dragInfo,
  style,
  isEditable,
  ...dragHandleProps
}, dragHandleRef) => {
  const {
    isOver,
    isDragging,
    draggingIndex,
    index
  } = dragInfo;
  const panels = (0, _control_group_container.controlGroupSelector)(state => state.explicitInput.panels);
  const grow = panels[embeddableId].grow;
  const width = panels[embeddableId].width;
  const title = panels[embeddableId].explicitInput.title;
  const dragHandle = /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
    ref: dragHandleRef
  }, dragHandleProps, {
    "aria-label": `${_control_group_strings.ControlGroupStrings.ariaActions.getMoveControlButtonAction(title)}`,
    className: "controlFrame__dragHandle"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grabHorizontal"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: grow,
    "data-control-id": embeddableId,
    "data-test-subj": `control-frame`,
    "data-render-complete": "true",
    className: (0, _classnames.default)('controlFrameWrapper', {
      'controlFrameWrapper-isDragging': isDragging,
      'controlFrameWrapper-isEditable': isEditable,
      'controlFrameWrapper--small': width === 'small',
      'controlFrameWrapper--medium': width === 'medium',
      'controlFrameWrapper--large': width === 'large',
      'controlFrameWrapper--insertBefore': isOver && (index !== null && index !== void 0 ? index : -1) < (draggingIndex !== null && draggingIndex !== void 0 ? draggingIndex : -1),
      'controlFrameWrapper--insertAfter': isOver && (index !== null && index !== void 0 ? index : -1) > (draggingIndex !== null && draggingIndex !== void 0 ? draggingIndex : -1)
    }),
    style: style
  }, /*#__PURE__*/_react.default.createElement(_control_frame_component.ControlFrame, {
    enableActions: draggingIndex === -1,
    embeddableId: embeddableId,
    embeddableType: embeddableType,
    customPrepend: isEditable ? dragHandle : undefined
  }));
});

/**
 * A simplified clone version of the control which is dragged. This version only shows
 * the title, because individual controls can be any size, and dragging a wide item
 * can be quite cumbersome.
 */
const ControlClone = ({
  draggingId
}) => {
  const panels = (0, _control_group_container.controlGroupSelector)(state => state.explicitInput.panels);
  const controlStyle = (0, _control_group_container.controlGroupSelector)(state => state.explicitInput.controlStyle);
  const width = panels[draggingId].width;
  const title = panels[draggingId].explicitInput.title;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: (0, _classnames.default)('controlFrameCloneWrapper', {
      'controlFrameCloneWrapper--small': width === 'small',
      'controlFrameCloneWrapper--medium': width === 'medium',
      'controlFrameCloneWrapper--large': width === 'large',
      'controlFrameCloneWrapper--twoLine': controlStyle === 'twoLine'
    })
  }, controlStyle === 'twoLine' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, title) : undefined, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    className: 'controlFrame__draggable'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grabHorizontal",
    className: "controlFrame__dragHandle"
  })), controlStyle === 'oneLine' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("label", {
    className: "controlFrameCloneWrapper__label"
  }, title)) : undefined));
};
exports.ControlClone = ControlClone;