"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlError = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ControlError = ({
  error
}) => {
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const errorMessage = error instanceof Error ? error.message : error;
  const popoverButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    iconSize: "m",
    iconType: "error",
    "data-test-subj": "control-frame-error",
    onClick: () => setPopoverOpen(open => !open),
    className: 'errorEmbeddableCompact__button',
    textProps: {
      className: 'errorEmbeddableCompact__text'
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "controls.frame.error.message",
    defaultMessage: "An error occurred. View more"
  }));
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: popoverButton,
    isOpen: isPopoverOpen,
    className: "errorEmbeddableCompact__popover",
    anchorClassName: "errorEmbeddableCompact__popoverAnchor",
    closePopover: () => setPopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_public.Markdown, {
    markdown: errorMessage,
    openLinksInNewTab: true,
    "data-test-subj": "errorMessageMarkdown"
  })));
};
exports.ControlError = ControlError;