"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditControlAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _public3 = require("@kbn/ui-actions-plugin/public");
var _services = require("../../services");
var _edit_control_flyout = require("./edit_control_flyout");
var _control_group_strings = require("../control_group_strings");
var _ = require("..");
var _control_group_container = require("../embeddable/control_group_container");
var _control_group_helpers = require("../embeddable/control_group_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class EditControlAction {
  constructor(deleteControlAction) {
    (0, _defineProperty2.default)(this, "type", _.ACTION_EDIT_CONTROL);
    (0, _defineProperty2.default)(this, "id", _.ACTION_EDIT_CONTROL);
    (0, _defineProperty2.default)(this, "order", 2);
    (0, _defineProperty2.default)(this, "getEmbeddableFactory", void 0);
    (0, _defineProperty2.default)(this, "openFlyout", void 0);
    (0, _defineProperty2.default)(this, "theme$", void 0);
    (0, _defineProperty2.default)(this, "MenuItem", ({
      context
    }) => {
      const {
        embeddable
      } = context;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: this.getDisplayName(context)
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": `control-action-${embeddable.id}-edit`,
        "aria-label": this.getDisplayName(context),
        iconType: this.getIconType(context),
        onClick: () => this.execute(context),
        color: "text"
      }));
    });
    this.deleteControlAction = deleteControlAction;
    ({
      embeddable: {
        getEmbeddableFactory: this.getEmbeddableFactory
      },
      overlays: {
        openFlyout: this.openFlyout
      },
      theme: {
        theme$: this.theme$
      }
    } = _services.pluginServices.getServices());
  }
  getDisplayName({
    embeddable
  }) {
    if (!embeddable.parent || !(0, _control_group_helpers.isControlGroup)(embeddable.parent)) {
      throw new _public3.IncompatibleActionError();
    }
    return _control_group_strings.ControlGroupStrings.floatingActions.getEditButtonTitle();
  }
  getIconType({
    embeddable
  }) {
    if (!embeddable.parent || !(0, _control_group_helpers.isControlGroup)(embeddable.parent)) {
      throw new _public3.IncompatibleActionError();
    }
    return 'pencil';
  }
  async isCompatible({
    embeddable
  }) {
    if ((0, _public2.isErrorEmbeddable)(embeddable)) return false;
    const controlGroup = embeddable.parent;
    const factory = this.getEmbeddableFactory(embeddable.type);
    return Boolean(controlGroup && (0, _control_group_helpers.isControlGroup)(controlGroup) && controlGroup.getInput().viewMode === _public2.ViewMode.EDIT && factory && (await factory.isEditable()));
  }
  async execute({
    embeddable
  }) {
    if (!embeddable.parent || !(0, _control_group_helpers.isControlGroup)(embeddable.parent)) {
      throw new _public3.IncompatibleActionError();
    }
    const controlGroup = embeddable.parent;
    const flyoutInstance = this.openFlyout((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_control_group_container.ControlGroupContainerContext.Provider, {
      value: controlGroup
    }, /*#__PURE__*/_react.default.createElement(_edit_control_flyout.EditControlFlyout, {
      embeddable: embeddable,
      removeControl: () => this.deleteControlAction.execute({
        embeddable
      }),
      closeFlyout: () => {
        (0, _control_group_container.setFlyoutRef)(undefined);
        flyoutInstance.close();
      }
    })), {
      theme$: this.theme$
    }), {
      'aria-label': _control_group_strings.ControlGroupStrings.manageControl.getFlyoutEditTitle(),
      outsideClickCloses: false,
      onClose: flyout => {
        (0, _control_group_container.setFlyoutRef)(undefined);
        flyout.close();
      },
      ownFocus: true
    });
    (0, _control_group_container.setFlyoutRef)(flyoutInstance);
  }
}
exports.EditControlAction = EditControlAction;