"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IdAutocompleteComponent = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _shared_component = require("./shared_component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class IdAutocompleteComponent extends _shared_component.SharedComponent {
  constructor(name, parent, multi) {
    super(name, parent);
    this.multi_match = multi;
  }
  match(token, context, editor) {
    if (!token) {
      return null;
    }
    if (!this.multi_match && Array.isArray(token)) {
      return null;
    }
    token = Array.isArray(token) ? token : [token];
    if (_lodash.default.find(token, function (t) {
      return t.match(/[\/,]/);
    })) {
      return null;
    }
    const r = super.match(token, context, editor);
    r.context_values = r.context_values || {};
    r.context_values.id = token;
    return r;
  }
}
exports.IdAutocompleteComponent = IdAutocompleteComponent;