"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineFindCspRuleTemplateRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _get_csp_rule_template = require("../../../common/schemas/csp_rule_template_api/get_csp_rule_template");
var _helpers = require("../../../common/utils/helpers");
var _constants = require("../../../common/constants");
var _benchmarks = require("../benchmarks/benchmarks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBenchmarkIdFromPackagePolicyId = async (soClient, packagePolicyId) => {
  const res = await soClient.get(_benchmarks.PACKAGE_POLICY_SAVED_OBJECT_TYPE, packagePolicyId);
  return (0, _helpers.getBenchmarkFromPackagePolicy)(res.attributes.inputs);
};
const findCspRuleTemplateHandler = async (soClient, options) => {
  if (!options.packagePolicyId && !options.benchmarkId || options.packagePolicyId && options.benchmarkId) {
    throw new Error('Please provide either benchmarkId or packagePolicyId, but not both');
  }
  const benchmarkId = options.benchmarkId ? options.benchmarkId : await getBenchmarkIdFromPackagePolicyId(soClient, options.packagePolicyId);
  const cspRulesTemplatesSo = await soClient.find({
    type: _constants.CSP_RULE_TEMPLATE_SAVED_OBJECT_TYPE,
    searchFields: options.searchFields,
    search: options.search ? `"${options.search}"*` : '',
    page: options.page,
    perPage: options.perPage,
    sortField: options.sortField,
    fields: options === null || options === void 0 ? void 0 : options.fields,
    filter: (0, _helpers.getBenchmarkTypeFilter)(benchmarkId)
  });
  const cspRulesTemplates = cspRulesTemplatesSo.saved_objects.map(cspRuleTemplate => cspRuleTemplate.attributes);
  return {
    items: cspRulesTemplates,
    total: cspRulesTemplatesSo.total,
    page: options.page,
    perPage: options.perPage
  };
};
const defineFindCspRuleTemplateRoute = router => router.versioned.get({
  access: 'internal',
  path: _constants.FIND_CSP_RULE_TEMPLATE_ROUTE_PATH
}).addVersion({
  version: '1',
  validate: {
    request: {
      query: _get_csp_rule_template.findCspRuleTemplateRequest
    }
  }
}, async (context, request, response) => {
  if (!(await context.fleet).authz.fleet.all) {
    return response.forbidden();
  }
  const requestBody = request.query;
  const cspContext = await context.csp;
  try {
    const cspRulesTemplates = await findCspRuleTemplateHandler(cspContext.soClient, requestBody);
    return response.ok({
      body: cspRulesTemplates
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    cspContext.logger.error(`Failed to fetch csp rules templates ${err}`);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
});
exports.defineFindCspRuleTemplateRoute = defineFindCspRuleTemplateRoute;