"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCspmUsageCollector = registerCspmUsageCollector;
var _indices_stats_collector = require("./indices_stats_collector");
var _resources_stats_collector = require("./resources_stats_collector");
var _schema = require("./schema");
var _accounts_stats_collector = require("./accounts_stats_collector");
var _rules_stats_collector = require("./rules_stats_collector");
var _installation_stats_collector = require("./installation_stats_collector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerCspmUsageCollector(logger, coreServices, usageCollection) {
  // usageCollection is an optional dependency, so make sure to return if it is not registered
  if (!usageCollection) {
    return;
  }

  // Create usage collector
  const cspmUsageCollector = usageCollection.makeUsageCollector({
    type: 'cloud_security_posture',
    isReady: async () => {
      await coreServices;
      return true;
    },
    fetch: async collectorFetchContext => {
      const [indicesStats, accountsStats, resourcesStats, rulesStats, installationStats] = await Promise.all([(0, _indices_stats_collector.getIndicesStats)(collectorFetchContext.esClient, collectorFetchContext.soClient, coreServices, logger), (0, _accounts_stats_collector.getAccountsStats)(collectorFetchContext.esClient, logger), (0, _resources_stats_collector.getResourcesStats)(collectorFetchContext.esClient, logger), (0, _rules_stats_collector.getRulesStats)(collectorFetchContext.esClient, logger), (0, _installation_stats_collector.getInstallationStats)(collectorFetchContext.esClient, collectorFetchContext.soClient, coreServices, logger)]);
      return {
        indices: indicesStats,
        accounts_stats: accountsStats,
        resources_stats: resourcesStats,
        rules_stats: rulesStats,
        installation_stats: installationStats
      };
    },
    schema: _schema.cspmUsageSchema
  });

  // Register usage collector
  usageCollection.registerCollector(cspmUsageCollector);
}