"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkIndexStatus = void 0;
var _get_safe_posture_type_runtime_mapping = require("../../common/runtime_mappings/get_safe_posture_type_runtime_mapping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const checkIndexStatus = async (esClient, index, logger, postureType) => {
  const query = !postureType || postureType === 'all' || postureType === 'vuln_mgmt' ? undefined : {
    bool: {
      filter: {
        term: {
          safe_posture_type: postureType
        }
      }
    }
  };
  try {
    const queryResult = await esClient.search({
      index,
      runtime_mappings: {
        ...(0, _get_safe_posture_type_runtime_mapping.getSafePostureTypeRuntimeMapping)()
      },
      query,
      size: 1
    });
    return queryResult.hits.hits.length ? 'not-empty' : 'empty';
  } catch (e) {
    var _e$meta, _e$meta$body, _e$meta$body$error;
    logger.debug(e);
    if ((e === null || e === void 0 ? void 0 : (_e$meta = e.meta) === null || _e$meta === void 0 ? void 0 : (_e$meta$body = _e$meta.body) === null || _e$meta$body === void 0 ? void 0 : (_e$meta$body$error = _e$meta$body.error) === null || _e$meta$body$error === void 0 ? void 0 : _e$meta$body$error.type) === 'security_exception') {
      return 'unprivileged';
    }

    // Assuming index doesn't exist
    return 'empty';
  }
};
exports.checkIndexStatus = checkIndexStatus;