"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.latestIndexConfigs = void 0;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const latestIndexConfigs = {
  findings: {
    indexName: _constants.FINDINGS_INDEX_NAME,
    indexPattern: _constants.LATEST_FINDINGS_INDEX_PATTERN,
    indexTemplateName: _constants.LATEST_FINDINGS_INDEX_TEMPLATE_NAME,
    indexDefaultName: _constants.LATEST_FINDINGS_INDEX_DEFAULT_NS
  },
  vulnerabilities: {
    indexName: _constants.VULNERABILITIES_INDEX_NAME,
    indexPattern: _constants.LATEST_VULNERABILITIES_INDEX_PATTERN,
    indexTemplateName: _constants.LATEST_VULNERABILITIES_INDEX_TEMPLATE_NAME,
    indexDefaultName: _constants.LATEST_VULNERABILITIES_INDEX_DEFAULT_NS
  }
};
exports.latestIndexConfigs = latestIndexConfigs;